import bpy


def IGMaterialMapping():

	# create a group
	map_group = bpy.data.node_groups.new(
		'IG Material Mapping', 'ShaderNodeTree')

	# create group inputs
	group_inputs = map_group.nodes.new('NodeGroupInput')
	group_inputs.location = (1000, 0)

	map_group.inputs.new('NodeSocketVector', 'Vector')
	map_group.inputs.new('NodeSocketVector', 'Rotation')
	map_group.inputs.new('NodeSocketVector', 'Scale')
	map_group.inputs.new('NodeSocketVector', 'Translation')

	group_outputs = map_group.nodes.new('NodeGroupOutput')
	group_outputs.location = (1800, 0)
	map_group.outputs.new('NodeSocketVector', 'Vector')

	# create nodes

	node_v1 = map_group.nodes.new('ShaderNodeMapping')
	node_v1.location = (1200, 0)
	node_v1.vector_type = 'POINT'
	
	node_v2 = map_group.nodes.new('ShaderNodeVectorMath')
	node_v2.location = (1400,0)
	node_v2.operation = 'MULTIPLY'

	node_v3 = map_group.nodes.new('ShaderNodeVectorMath')
	node_v3.location = (1600,0)
	node_v3.operation = 'ADD'

	# link nodes

	map_group.links.new(node_v1.inputs[0], group_inputs.outputs['Vector'])
	map_group.links.new(node_v1.inputs[2], group_inputs.outputs['Rotation'])

	map_group.links.new(node_v2.inputs[0], node_v1.outputs[0])
	map_group.links.new(node_v2.inputs[1], group_inputs.outputs['Scale'])

	map_group.links.new(node_v3.inputs[0], node_v2.outputs[0])
	map_group.links.new(node_v3.inputs[1], group_inputs.outputs['Translation'])

	map_group.links.new(group_outputs.inputs['Vector'], node_v3.outputs[0])