import bpy
import datetime

def NormalMapCombine():
	print("NormalMapCombine Blender NodeCreator. Copyright (C) 2018 -",
		  datetime.datetime.now().year,"intelligentgraphics AG. All Rights Reserved.")
	# create a group
	nmc_group = bpy.data.node_groups.new('Normal Map Combine', 'ShaderNodeTree')

	# create group inputs
	group_inputs = nmc_group.nodes.new('NodeGroupInput')
	group_inputs.location = (-1800,0)
	nmc_group.inputs.new('NodeSocketColor','Base')
	nmc_group.inputs.new('NodeSocketColor','Detail')
	nmc_group.inputs.new('NodeSocketFloat','fac')
	nmc_group.inputs[0].default_value = (0.502886, 0.502887, 1, 1)
	nmc_group.inputs[1].default_value = (0.502886, 0.502887, 1, 1)
	nmc_group.inputs[2].default_value = 1.0
	nmc_group.inputs[2].min_value = 0
	nmc_group.inputs[2].max_value = 1


	# create group outputs
	group_outputs = nmc_group.nodes.new('NodeGroupOutput')
	group_outputs.location = (1800,0)
	nmc_group.outputs.new('NodeSocketColor','Colour')

	# create nodes
	node_v1 = nmc_group.nodes.new('ShaderNodeValue')
	node_v1.outputs[0].default_value = 2.0
	node_v1.location = (-1800,400)

	node_v2 = nmc_group.nodes.new('ShaderNodeValue')
	node_v2.outputs[0].default_value = -1.0
	node_v2.location = (-1800,200)

	node_v3 = nmc_group.nodes.new('ShaderNodeValue')
	node_v3.outputs[0].default_value = -2.0
	node_v3.location = (-1800,-200)

	node_v4 = nmc_group.nodes.new('ShaderNodeValue')
	node_v4.outputs[0].default_value = 2.0
	node_v4.location = (-1800,-400)

	node_v5 = nmc_group.nodes.new('ShaderNodeValue')
	node_v5.outputs[0].default_value = 1.0
	node_v5.location = (-1800,-600)

	node_v6 = nmc_group.nodes.new('ShaderNodeValue')
	node_v6.outputs[0].default_value = -1.0
	node_v6.location = (-1800,-800)

	node_v7 = nmc_group.nodes.new('ShaderNodeValue')
	node_v7.outputs[0].default_value = 0.5
	node_v7.location = (-1800,600)




	node_comb21 = nmc_group.nodes.new('ShaderNodeCombineRGB')
	node_comb21.hide = True
	node_comb21.location = (-1500,-300)

	node_comb22 = nmc_group.nodes.new('ShaderNodeCombineRGB')
	node_comb22.hide = True
	node_comb22.location = (-1500,-700)




	node_col31 = nmc_group.nodes.new('ShaderNodeMixRGB')
	node_col31.blend_type = 'MULTIPLY'
	node_col31.inputs[0].default_value = 1.0
	node_col31.hide = True
	node_col31.location = (-1200,300)

	node_add31 = nmc_group.nodes.new('ShaderNodeMath')
	node_add31.operation = 'ADD'
	node_add31.hide = True
	node_add31.location = (-1200,100)

	node_col32 = nmc_group.nodes.new('ShaderNodeMixRGB')
	node_col32.blend_type = 'MULTIPLY'
	node_col32.inputs[0].default_value = 1.0
	node_col32.hide = True
	node_col32.location = (-1200,-100)




	node_comb41 = nmc_group.nodes.new('ShaderNodeCombineRGB')
	node_comb41.hide = True
	node_comb41.location = (-900,200)




	node_col51 = nmc_group.nodes.new('ShaderNodeMixRGB')
	node_col51.blend_type = 'ADD'
	node_col51.inputs[0].default_value = 1.0
	node_col51.hide = True
	node_col51.location = (-600,300)

	node_col52 = nmc_group.nodes.new('ShaderNodeMixRGB')
	node_col52.blend_type = 'ADD'
	node_col52.inputs[0].default_value = 1.0
	node_col52.hide = True
	node_col52.location = (-600,-400)




	node_dot6 = nmc_group.nodes.new('ShaderNodeVectorMath')
	node_dot6.operation = 'DOT_PRODUCT'
	node_dot6.hide = True
	node_dot6.location = (-300,100)

	node_sep6 = nmc_group.nodes.new('ShaderNodeSeparateRGB')
	node_sep6.hide = True
	node_sep6.location = (-300,-100)




	node_col7 = nmc_group.nodes.new('ShaderNodeMixRGB')
	node_col7.blend_type = 'DIVIDE'
	node_col7.inputs[0].default_value = 1.0
	node_col7.hide = True
	node_col7.location = (0,0)

	node_col8 = nmc_group.nodes.new('ShaderNodeMixRGB')
	node_col8.blend_type = 'MULTIPLY'
	node_col8.inputs[0].default_value = 1.0
	node_col8.hide = True
	node_col8.location = (300,0)

	node_col9 = nmc_group.nodes.new('ShaderNodeMixRGB')
	node_col9.blend_type = 'SUBTRACT'
	node_col9.inputs[0].default_value = 1.0
	node_col9.hide = True
	node_col9.location = (600,0)

	node_norm10 = nmc_group.nodes.new('ShaderNodeVectorMath')
	node_norm10.operation = 'NORMALIZE'
	node_norm10.inputs[1].default_value = [1,1,1]
	node_norm10 .hide = True
	node_norm10 .location = (900,0)

	node_col11 = nmc_group.nodes.new('ShaderNodeMixRGB')
	node_col11.blend_type = 'MULTIPLY'
	node_col11.inputs[0].default_value = 1.0
	node_col11.hide = True
	node_col11.location = (1200,0)

	node_col12 = nmc_group.nodes.new('ShaderNodeMixRGB')
	node_col12.blend_type = 'ADD'
	node_col12.inputs[0].default_value = 1.0
	node_col12.hide = True
	node_col12.location = (1500,0)




	# link nodes together
	nmc_group.links.new(node_comb21.inputs[0], node_v3.outputs[0])
	nmc_group.links.new(node_comb21.inputs[1], node_v3.outputs[0])
	nmc_group.links.new(node_comb21.inputs[2], node_v4.outputs[0])

	nmc_group.links.new(node_comb22.inputs[0], node_v5.outputs[0])
	nmc_group.links.new(node_comb22.inputs[1], node_v5.outputs[0])
	nmc_group.links.new(node_comb22.inputs[2], node_v6.outputs[0])



	nmc_group.links.new(node_col31.inputs[1], node_v1.outputs[0])
	nmc_group.links.new(node_col31.inputs[2], group_inputs.outputs['Base'])

	nmc_group.links.new(node_add31.inputs[0], node_v2.outputs[0])
	nmc_group.links.new(node_add31.inputs[1], group_inputs.outputs['fac'])

	nmc_group.links.new(node_col32.inputs[1], group_inputs.outputs['Detail'])
	nmc_group.links.new(node_col32.inputs[2], node_comb21.outputs[0])



	nmc_group.links.new(node_comb41.inputs[0], node_v2.outputs[0])
	nmc_group.links.new(node_comb41.inputs[1], node_v2.outputs[0])
	nmc_group.links.new(node_comb41.inputs[2], node_add31.outputs[0])



	nmc_group.links.new(node_col51.inputs[1], node_col31.outputs[0])
	nmc_group.links.new(node_col51.inputs[2], node_comb41.outputs[0])

	nmc_group.links.new(node_col52.inputs[1], node_col32.outputs[0])
	nmc_group.links.new(node_col52.inputs[2], node_comb22.outputs[0])



	nmc_group.links.new(node_dot6.inputs[0], node_col51.outputs[0])
	nmc_group.links.new(node_dot6.inputs[1], node_col52.outputs[0])

	nmc_group.links.new(node_sep6.inputs[0], node_col51.outputs[0])



	nmc_group.links.new(node_col7.inputs[1], node_dot6.outputs[1])
	nmc_group.links.new(node_col7.inputs[2], node_sep6.outputs[2])

	nmc_group.links.new(node_col8.inputs[0], group_inputs.outputs['fac'])
	nmc_group.links.new(node_col8.inputs[1], node_col51.outputs[0])
	nmc_group.links.new(node_col8.inputs[2], node_col7.outputs[0])

	nmc_group.links.new(node_col9.inputs[0], group_inputs.outputs['fac'])
	nmc_group.links.new(node_col9.inputs[1], node_col8.outputs[0])
	nmc_group.links.new(node_col9.inputs[2], node_col52.outputs[0])

	nmc_group.links.new(node_norm10.inputs[0], node_col9.outputs[0])

	nmc_group.links.new(node_col11.inputs[1], node_norm10.outputs[0])
	nmc_group.links.new(node_col11.inputs[2], node_v7.outputs[0])

	nmc_group.links.new(node_col12.inputs[1], node_col11.outputs[0])
	nmc_group.links.new(node_col12.inputs[2], node_v7.outputs[0])

	nmc_group.links.new(group_outputs.inputs[0], node_col12.outputs[0])