import bpy
import bmesh
import os
import re
import math
import mathutils
import json
import pathlib
import datetime
import importlib
import types
from bpy.props import *
import logging

from sys import platform as _platform
version = "3.4"

global tUseAbsPath
tUseAbsPath =False

global BasePath
BasePath = ""

def checkForCtmImporter():
	import bpy as _bpy
	from addon_utils import paths

	path_list = paths()

	for path in path_list:
		_bpy.utils._sys_path_ensure_append(path)
		for mod_name, mod_path in _bpy.path.module_names(path):
			if "ctm" in mod_name.lower() and "import" in mod_name.lower():
				print("CTM importer found")
				return True
	return False

def loadScript(name): 
	def loadModule(path, name):
		loader = importlib.machinery.SourceFileLoader(
			name, os.path.join(path, name +".py"))
		mod = types.ModuleType(loader.name)
		# loader.load_module(mod)
		return loader.load_module(loader.name)
		# loader.exec_module(mod)

	sharedFolder = "Path to NormalMapCombine"

	if bpy.app.background:
		# use this if script started form CMD or Terminal
		try:  # in Shared folder
			sharedFolder = os.path.join(
				os.path.dirname(__file__) + ".", "Shared")
			return loadModule(sharedFolder, name)
		except OSError:  # in same directory
			sharedFolder = os.path.dirname(__file__)
			return loadModule(sharedFolder, name)
	else:  # use this if script started from blender
		print("Inside OC Importer", os.path.dirname(__file__))
		try:  # in Shared folder
			dirName = os.path.dirname(__file__)

			sharedFolder = os.path.join(
				dirName, "..", "Shared")
			return loadModule(sharedFolder, name)
		except:  # in same directory
			sharedFolder = os.path.dirname(__file__)
			return loadModule(sharedFolder, name)

# load/import scene file:
def importScene(index, indexes, path, environment):
	if checkForCtmImporter():
		NormalMapCombine = loadScript('NormalMapCombine')
		NormalMapCombine.NormalMapCombine()
		MaterialMapping = loadScript('IGMaterialMapping')
		MaterialMapping.IGMaterialMapping()

		print("OC Blender Importer", version, "Copyright (C) 2020 -",
			datetime.datetime.now().year, "intelligentgraphics AG. All Rights Reserved.")

		# load scene file:
		# if ".json" in index[indexes]:
		print("INFO", "Processing", index[indexes], "... (json Mode)")
		tFolderPath = index[indexes].rsplit(path, 1)[0] + path
		tScene = json.loads(
			open(tFolderPath + index[indexes].rsplit(path, 1)[1]).read())
		# else:
		# 	print("INFO", "Processing", index[indexes], "... (OC2GO Mode)")
		# 	tFolderPath = index[indexes] + path
		# 	tScene = json.loads(open(tFolderPath + "Scene.json").read())

		# check for BasePath and BasePath is no web directory

		if tScene.get("basePath", None) is not None:
			if not ("http:" in tScene["basePath"]) and not ("https:" in tScene["basePath"]):
				global tUseAbsPath
				tUseAbsPath = True
				global BasePath
				BasePath = tScene["basePath"]

		# remove unused materials:
		for tMaterial in bpy.data.materials:
			if tMaterial.name != "zDummy":
				if tMaterial.users == 0:
					tMaterial.user_clear()
					bpy.data.materials.remove(tMaterial)

				for tTexture in bpy.data.textures:
					if tTexture.users == 0:
						bpy.data.textures.remove(tTexture)

		# create the materials:
		importMaterials(tScene, tFolderPath, environment)

		tGeometries = tScene["geometries"]
		tProducts = tScene["products"]
		# tMaterialCategories = tProducts["materialCategories"]
		
		# # put all single products under one empty
		bpy.ops.object.empty_add(type="PLAIN_AXES", radius=1, location=(
					0, 0, 0), rotation=(0, -0, 0))
		bpy.context.object.name = "."

		#make sure scene is not empty
		for i, product in enumerate(tProducts):
			tMaterialCategories = {}
			tPosition = {}
			tRotation = {}
			tMaterialCategories = product.get("materialCategories",{})

			if "transform" in product:
				tPosition = product["transform"].get("position", {})
				tRotation = product["transform"].get("rotation",{})

			structure = product.get("structure",{})
			if len(structure) > 0:
				for tNode in structure:
					importOCNode(tNode, i, tMaterialCategories,
								tGeometries, tFolderPath, environment, tScene, tPosition, tRotation)

			for geometry in tGeometries:
				if "normalMap" in tGeometries[geometry]["ig"] and len(tGeometries[geometry]["ig"]["normalMap"]) > 0:
					if "parameters" in tGeometries[geometry]["ig"] and len(tGeometries[geometry]["ig"]["parameters"]) > 0:
						tGeometriesParameters = tGeometries[geometry]["ig"]["parameters"]
						if "NormalMapStrength" in tGeometriesParameters:
							tNormalmapStrength = tGeometriesParameters["NormalMapStrength"]
							addNormalsGeometry(
						tScene, geometry, tGeometries[geometry]["ig"]["normalMap"], tFolderPath, environment, tNormalmapStrength)
						else:
							addNormalsGeometry(
							tScene, geometry, tGeometries[geometry]["ig"]["normalMap"], tFolderPath, environment)
					else:
						addNormalsGeometry(
							tScene, geometry, tGeometries[geometry]["ig"]["normalMap"], tFolderPath, environment)
	else:
		print("Error", "CTM Importer not found!")
		print("Make sure it is installed from the Tools repository")
	
	
# End importScene(index,indexes, path, environment)

def buildAbsPath(folderPath, path):
	if tUseAbsPath:
		return os.path.join(BasePath,path)
	else:
		return os.path.join(folderPath,path)

def imagesLoad(folderPath, texturePath): 
	return bpy.data.images.load(buildAbsPath(folderPath, texturePath))

def importMaterials(scene, folderPath, environment):

	def importNodeMaterial(scene, folderPath, environment):	

		def CreateTextureSetUp(pbrNode, OCMaterial, blenderMaterial, folderPath, pathId):

			tTexturePath = pathId

			tTexturImage = imagesLoad(folderPath, tTexturePath)

			tNode4Image = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeTexImage")
			tNode4Image.image = tTexturImage
			tNode4Image.location = (-600, 300)

			# set up bumpmap here???

			# link image with pbr
			tLink = tMaterial.node_tree.links.new(
				tNode4Image.outputs[0], pbrNode.inputs[0])  # Color -> Color

			# link bump here???

		def CreateTextureNormalSetUp(pbrNode, OCMaterial, blenderMaterial, folderPath):
			tNormal = OCMaterial["normal"]
			if "texture" in OCMaterial:
				tTexturePath = OCMaterial["texture"]  # Name of normal map
			elif "diffuse" in OCMaterial:
				tTexturePath = OCMaterial["diffuse"]
			else:
				print("ERROR", "No Normalmap found for:", OCMaterial)

			if("map" in tNormal):
				tTexturePath = tNormal["map"]["map"]

			tTextureImage = imagesLoad(folderPath, tTexturePath)

			tNode4Normals = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeTexImage")
			tNode4Normals.image = tTextureImage
			tNode4Normals.location = (-1000, -300)
			tNode4Normals.name = "NormalsTexture"
			tNode4Normals.image.colorspace_settings.name = 'Non-Color'

			# set up NormalMapCombine
			tNode5NormalCombine = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeGroup")
			tNode5NormalCombine.node_tree = bpy.data.node_groups["Normal Map Combine"]
			tNode5NormalCombine.name = "NormalMapCombineGroup"


			tNode5NormalCombine.inputs[2].default_value = 0.2
			tNode5NormalCombine.location = (-600, -300)

			tLink1 = tMaterial.node_tree.links.new(
				tNode4Normals.outputs[0], tNode5NormalCombine.inputs[1])

			if "roughness" not in OCMaterial:
				# create roughness map out of normal map
				tNode6RGBtoBW = tMaterial.node_tree.nodes.new(
					type="ShaderNodeRGBToBW")
				tNode6RGBtoBW.location = (-600, -0)

				tNode7ColorRamp = tMaterial.node_tree.nodes.new(
					type="ShaderNodeValToRGB")  # Color Ramp
				tNode7ColorRamp.location = (-400, -0)

				tNode7ColorRamp.color_ramp.elements[0].color = (1, 1, 1, 1)
				tNode7ColorRamp.color_ramp.elements[1].color = (
					0.133, 0.133, 0.133, 1)
				tNode7ColorRamp.color_ramp.elements[1].position = 1
				tNode7ColorRamp.color_ramp.elements[0].position = 0.409091

				tLink2 = blenderMaterial.node_tree.links.new(
					tNode4Normals.outputs[0], tNode6RGBtoBW.inputs[0])
				tLink3 = blenderMaterial.node_tree.links.new(
					tNode6RGBtoBW.outputs[0], tNode7ColorRamp.inputs[0])
				tLink4 = blenderMaterial.node_tree.links.new(
					tNode7ColorRamp.outputs[0], pbrNode.inputs[7])		 # roughness

			# finish normal map creation

			tNodeNormalMap = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeNormalMap")
			tNodeNormalMap.location = (-400, -230)
			tNodeNormalMap.uv_map = "diffuse_map"
			tNodeNormalMap.inputs[0].default_value = 2

			tLink5 = blenderMaterial.node_tree.links.new(
				tNode5NormalCombine.outputs[0], tNodeNormalMap.inputs[1])
			tLink6 = blenderMaterial.node_tree.links.new(
				tNodeNormalMap.outputs[0], pbrNode.inputs[20])		 # normal

		def CreateTextureMappingSetUp(mappingType, OCMaterial, blenderMaterial):
			tNodeImageTex = None
			tNodeImageTex = blenderMaterial.node_tree.nodes.get(
				"Image Texture")
			if tNodeImageTex is None:
				tNodeImageTex = blenderMaterial.node_tree.nodes.get(
				"Image Rough Texture")

			tNodeTexCoord = None
			tNodeTexCoord = blenderMaterial.node_tree.nodes.get(
				"Texture Coordinate")
			if tNodeTexCoord is None:
				tNodeTexCoord = blenderMaterial.node_tree.nodes.get(
				"UV Map Mapping")

			# TO DO: Check if this is the same as in oc
			tMapping = mappingType
			tTranslationS = 0
			tTranslationT = 0
			tRotation = 0
			tScaleS = 1
			tScaleT = 1

			if tMapping != None:
				tTranslationS = tMapping.get("translationS", 0)
				tTranslationT = tMapping.get("translationT", 0)
				tRotation = tMapping.get("rotation",0)
				tScaleS = 1/tMapping.get("scaleS",1)
				tScaleT = 1/tMapping.get("scaleT",1)
			 
			tNodeMapping = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeGroup")
			tNodeMapping.node_tree = bpy.data.node_groups["IG Material Mapping"]
			tNodeMapping.name = "MaterialMappingGroup"
			tNodeMapping.location = (-1500, 300)
			tNodeMapping.inputs["Rotation"].default_value[2] = math.pi/180 * tRotation
			tNodeMapping.inputs["Scale"].default_value = (tScaleS, tScaleT, 1)
			tNodeMapping.inputs["Translation"].default_value = (tTranslationS, tTranslationT, 0)

			tNodeUVMapping = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeUVMap")
			tNodeUVMapping.name = "UV Map Mapping"
			tNodeUVMapping.location = (-1800, 300)
			tNodeUVMapping.uv_map = "diffuse_map" 


			tLink1 = blenderMaterial.node_tree.links.new(
				tNodeUVMapping.outputs[0], tNodeMapping.inputs[0])

			if tNodeImageTex is not None:
				tLink2 = blenderMaterial.node_tree.links.new(
					tNodeMapping.outputs[0], tNodeImageTex.inputs[0])
			# else. in case there is no image texture mapping for diffuse color is not needed

			if tNodeTexCoord is not None:
				tLink3 = blenderMaterial.node_tree.links.new(tNodeTexCoord.outputs[2], tNodeMapping.inputs["Vector"])
			if "normal" in OCMaterial:
				tNodeNormalTex = None
				tNodeNormalTex = blenderMaterial.node_tree.nodes.get(
					"NormalsTexture")
				if tNodeNormalTex is not None:
					tLink3 = blenderMaterial.node_tree.links.new(
						tNodeMapping.outputs[0], tNodeNormalTex.inputs[0])
			if "roughness" in OCMaterial:
				tNodeRoughTex = None
				tNodeRoughTex = blenderMaterial.node_tree.nodes.get(
					"Image Rough Texture")
				if tNodeRoughTex is not None:
					tLink5 = blenderMaterial.node_tree.links.new(
						tNodeMapping.outputs[0], tNodeRoughTex.inputs[0])


		def CreateBumpSetUp(pbrNode, imageNode, normalNode, blenderMaterial, bump, bumpStrength = 0.2):
			if bump:
				tNode5Bump = blenderMaterial.node_tree.nodes.new(
					type="ShaderNodeBump")
				tNode5Bump.location = (-200, -300)
				tNode5Bump.inputs[0].default_value = bumpStrength
				tNode5Bump.inputs[1].default_value = 1.0

				if imageNode:
					tLink1 = blenderMaterial.node_tree.links.new(
						imageNode.outputs[0], tNode5Bump.inputs[2])
				if normalNode:
					tLink2 = blenderMaterial.node_tree.links.new(
						normalNode.outputs['Normal'], tNode5Bump.inputs['Normal'])
				tLink3 = blenderMaterial.node_tree.links.new(
					tNode5Bump.outputs[0], pbrNode.inputs[20])

		def CreateRoughnessSetUp(pbrNode, OCMaterial, blenderMaterial, folderPath):
			tRoughness = OCMaterial["roughness"]
			if "map" in tRoughness:
				tTexturePath = tRoughness["map"]["map"]
			
			tTextureImage = imagesLoad(folderPath, tTexturePath)

			tNode4Roughness = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeTexImage")
			tNode4Roughness.name = "Image Rough Texture"
			
			tNode4Roughness.image = tTextureImage
			tNode4Roughness.location = (-600, 100)
			tNode4Roughness.image.colorspace_settings.name = 'Non-Color'

			tLink2 =blenderMaterial.node_tree.links.new(
				tNode4Roughness.outputs[0], pbrNode.inputs[7])
		#end CreateRoughnessSetUp


		def CreateAlphaSetUp(pbrNode,alphaMap, blenderMaterial, folderPath):
			if alphaMap is not None:

				# setup cycles material settings for alpha map usage
				blenderMaterial.blend_method = "BLEND"
				blenderMaterial.use_backface_culling = True
				blenderMaterial.cycles.displacement_method = "BOTH"
				tAlphaMap = imagesLoad(folderPath, alphaMap)

				# create node setup
				tNodeAlpha = blenderMaterial.node_tree.nodes.new(
									type="ShaderNodeTexImage")
				tNodeAlpha.name = "Image Alpha Texture"
				tNodeAlpha.location = (-300,-600)
				tNodeAlpha.image = tAlphaMap

				tNodeTransparency = blenderMaterial.node_tree.nodes.new(
									type="ShaderNodeBsdfTransparent")
				tNodeTransparency.location = (-300, -900)
				

				tNodeMix = blenderMaterial.node_tree.nodes.new(
									type="ShaderNodeMixShader")
				tNodeMix.location = (200, -100)

				# use material node displacement instead of modifiere because fits better here
				tNodeDisplacement = blenderMaterial.node_tree.nodes.new(
									type="ShaderNodeDisplacement")
				tNodeDisplacement.location = (100, -900)
				tNodeDisplacement.space = "OBJECT"
				tNodeDisplacement.inputs[0].default_value = 0.003
				tNodeDisplacement.inputs[1].default_value = 0.002
				tNodeDisplacement.inputs[2].default_value = 0.1

				#link node setup

				tLinkAlphaPBR = blenderMaterial.node_tree.links.new(tNodeAlpha.outputs[0], pbrNode.inputs[19])
				tLinkAlphaMix = blenderMaterial.node_tree.links.new(tNodeAlpha.outputs[1], tNodeMix.inputs[0])
				tLinkTranspMix = blenderMaterial.node_tree.links.new(tNodeTransparency.outputs[0], tNodeMix.inputs[1])
				tLinkPBRMix = blenderMaterial.node_tree.links.new(pbrNode.outputs[0], tNodeMix.inputs[2])

				tNodeOutPut = blenderMaterial.node_tree.nodes.get("Material Output")

				tLinkDisplOutPut = blenderMaterial.node_tree.links.new(tNodeDisplacement.outputs[0], tNodeOutPut.inputs[2])

				#relink pbr, mix and out put
				# unlinke pbr and materialout
				tLinkOld = tNodeOutPut.inputs[0].links[0]
				tMaterial.node_tree.links.remove(tLinkOld)

				tLinkMixOut = blenderMaterial.node_tree.links.new(tNodeMix.outputs[0], tNodeOutPut.inputs[0])
		#end CreateAlphaSetUp
		

		def SetUpTaxonomies(pbrNode, ocMaterial, metal=0, specular=0, specularTint=0, roughness=0.5, sheen=0, sheenTint=0.5, clearcoat=0, clearcoatRouth=0.03):
			tTaxonomy = ocMaterial["taxonomy"]
			if tTaxonomy:
				
				pbrNode.inputs[4].default_value = metal
				pbrNode.inputs[5].default_value = specular
				pbrNode.inputs[6].default_value = specularTint
				pbrNode.inputs[7].default_value = roughness
				pbrNode.inputs[10].default_value = sheen
				pbrNode.inputs[11].default_value = sheenTint
				pbrNode.inputs[12].default_value = clearcoat
				pbrNode.inputs[13].default_value = clearcoatRouth

		def getColor(material, type):
			return [material[type]["color"].get("red",0),
					material[type]["color"].get("green",0),
					material[type]["color"].get("blue",0)]

		def Coating(type, pbrNode):
			if type == "sh":
				pbrNode.inputs[12].default_value = 1 #  clearcoat
				pbrNode.inputs[13].default_value = 0 #  clearcoatRouth
			elif type == "fi":
				# pbrNode.inputs[5].default_value = 0
				# pbrNode.inputs[6].default_value = 0
				pbrNode.inputs[12].default_value = 1 #  clearcoat
				pbrNode.inputs[13].default_value = 0.5 #  clearcoatRouth
			elif type == "an": 
				pbrNode.inputs[4].default_value = 0
				pbrNode.inputs[5].default_value = 0
				pbrNode.inputs[6].default_value = 0
				pbrNode.inputs[7].default_value = 0
				pbrNode.inputs[10].default_value = 0
				pbrNode.inputs[11].default_value = 0
				pbrNode.inputs[12].default_value = 0
				pbrNode.inputs[13].default_value = 0
			elif type == "wa":  # Wax
				pbrNode.inputs[12].default_value = 1	#  clearcoat
				pbrNode.inputs[13].default_value = 0.35 #  clearcoatRouth
			elif type == "oi":  # Oel
				pbrNode.inputs[11].default_value = 0.186
				pbrNode.inputs[12].default_value = 0.368
				pbrNode.inputs[13].default_value = 0.123
			elif type == "pu":  # Matratzenschaumstoff
				pbrNode.inputs[5].default_value = 0
				pbrNode.inputs[7].default_value = 1 # roughness
				pbrNode.inputs[12].default_value = 0 #  clearcoat
				pbrNode.inputs[13].default_value = 0 #  clearcoatRouth
			elif type == "ep":  # Epoxidharz
				pbrNode.inputs[5].default_value = 1  #  specular
				pbrNode.inputs[12].default_value =1  #  clearcoat
				pbrNode.inputs[13].default_value = 0 #  clearcoatRouth	

		if "materials" in scene:
			tMaterials = scene["materials"]
			for tMaterialName in tMaterials:
				# basic material properties
				tJMaterial = tMaterials[tMaterialName]["ig"]

				tMaterial = bpy.data.materials.new(tMaterialName)
				tMaterial.pass_index = 1  # set pass index for later compositing if glossy mirror
				tMaterial.use_nodes = True

				tDiffuse = getColor(tJMaterial, "diffuse")
				tSpecular = [0,0,0]
				tEmissive = [0,0,0]
				tMaterial.diffuse_color[0] = math.pow(tDiffuse[0], 2.2)
				tMaterial.diffuse_color[1] = math.pow(tDiffuse[1], 2.2)
				tMaterial.diffuse_color[2] = math.pow(tDiffuse[2], 2.2)
				if "specular" in tJMaterial:
					if "color" in tJMaterial["specular"]:
						tSpecular = getColor(tJMaterial, "specular")
						tMaterial.specular_color[0] = tSpecular[0]
						tMaterial.specular_color[1] = tSpecular[1]
						tMaterial.specular_color[2] = tSpecular[2]
				if "emissive" in tJMaterial:
					tEmissive = getColor(tJMaterial, "emissive")
					tMaterial.emissive_color[0] = tEmissive[0]
					tMaterial.emissive_color[1] = tEmissive[1]
					tMaterial.emissive_color[2] = tEmissive[2]

				tAlpha = tJMaterial.get("alpha", None)

				if "alpha" in tJMaterial:
					tTransparency = tJMaterial["alpha"].get("value",0)

				tUseBump = False
				tHasTexture = False
				tNodeTexCoord = None

				# get start node setup
				tNode2 = tMaterial.node_tree.nodes.get("Principled BSDF")

				tNode2.location = (0, 150)
				tNode2.inputs[0].default_value = (
					math.pow(tDiffuse[0], 2.2), math.pow(tDiffuse[1], 2.2), math.pow(tDiffuse[2], 2.2), 1)			# Diffuse Color
				tNode2.inputs[5].default_value = (
					tSpecular[0] + tSpecular[1] + tSpecular[2])/3		# Specular
				if "diffuse" in tJMaterial:
					tDiffuseMaterial = tJMaterial["diffuse"]
					if("map" in tDiffuseMaterial):
						CreateTextureSetUp(tNode2, tJMaterial,
										tMaterial, folderPath, tDiffuseMaterial["map"]["map"])
						tHasTexture = True
						tUseBump = True
						tNodeTexCoord = tMaterial.node_tree.nodes.new("ShaderNodeTexCoord")
						tNodeTexCoord.location = (-1000, 300)
						if "mapping" in tDiffuseMaterial["map"]:
							CreateTextureMappingSetUp(
							tDiffuseMaterial["map"]["mapping"], tJMaterial, tMaterial)
							tNodeTexCoord = tMaterial.node_tree.nodes.new("ShaderNodeTexCoord")
						else:
							tNodeImageTex = tMaterial.node_tree.nodes.get(
								"Image Texture")
							tLinkTexCoordImage = tMaterial.node_tree.links.new(tNodeTexCoord.outputs[2], tNodeImageTex.inputs["Vector"])
					else:
						tNode2.inputs[0].default_value = [
							math.pow(tDiffuse[0], 2.2), math.pow(tDiffuse[1], 2.2), math.pow(tDiffuse[2],2.2), 1]
						tUseBump = False
					
				else:
					tNode2.inputs[0].default_value = [
						math.pow(tDiffuse[0], 2.2), math.pow(tDiffuse[1], 2.2), math.pow(tDiffuse[2], 2.2), 1]
					tUseBump = False

				if "normal" in tJMaterial:
					CreateTextureNormalSetUp(
						tNode2, tJMaterial, tMaterial, folderPath)
					tUseBump = False
				else:
					if "texture" in tJMaterial:
						tUseBump = True

				tNodeColorRamp = None
				if "roughness" in tJMaterial:
					CreateRoughnessSetUp(
						tNode2, tJMaterial, tMaterial, folderPath)
				else:
					tNodeColorRamp = tMaterial.node_tree.nodes.get("ColorRamp") 
				

				if "mapping" in tJMaterial:
					CreateTextureMappingSetUp(
						tJMaterial["mapping"], tJMaterial, tMaterial)

				if "diffuseDelta" in tJMaterial:
					tDiffuseDeltaTexture = tJMaterial["diffuseDelta"]["map"]
					tDiffuseDeltaMapping = None
					if "mapping" in tJMaterial["diffuseDelta"]:
						tDiffuseDeltaMapping = tJMaterial["diffuseDelta"]["mapping"]

				if "roughnessDelta" in tJMaterial:
					tRoughnessDeltaTexture = tJMaterial["roughnessDelta"]["map"]
					tRoughnessDeltaMapping = None
					if "mapping" in tJMaterial["roughnessDelta"]:
						tRoughnessDeltaMapping = tJMaterial["roughnessDelta"]["mapping"]
				if tAlpha is not None:
					if "map" in tAlpha:
						tAlphaMap = tAlpha["map"].get("map", None)
						CreateAlphaSetUp(tNode2,tAlphaMap,tMaterial, folderPath)
				

				# evaluate taxonomies
				BumpStrength = 0.2
				# if "meta" in tJMaterial:
				# 	tMeta = tJMaterial["meta"]
				tTaxonomy = tJMaterial.get("taxonomy", None)
				if tTaxonomy is not None:
					tWoodIds = ["oak", "beech", "spruc",
								"pine", "maple", "chry", "teak"]
					tFabricIds = ["fabri"]
					tLeatherIds = ["leath"]
					tMetalIds = ["alu", "chro", "hqust", "iron",
								"coppr", "brass", "gold", "silvr"]
					tPolyIds = ["pvc", "polye"]
					tCeramIds = ["ceram"]
					tGlassIds = ["glass"]
					tVelvetIds = ["velv"]

					tMetaMaterialId = tTaxonomy["mat"]
					tRoughness = tTaxonomy.get("rou",0.5)
					tCoating = tTaxonomy.get("coa", "")

					if tMetaMaterialId in tWoodIds:
						SetUpTaxonomies(tNode2, tJMaterial,
										0,  # metal
										0.6,  # specular
										0,  # specularTint
										tRoughness,  # roughness
										0,  # sheen
										0.5,  # sheenTint
										0,  # clearcoat
										0.03  # clearcoatRouth
										)
						Coating(tCoating,tNode2)
						if tCoating == "fi":
							tUseBump = False
						if tCoating == "sh":
							tUseBump = False
						if tCoating == "wa":
							BumpStrength = 0.092
						if tCoating == "oi":
							BumpStrength = 0.067
					if tMetaMaterialId in tFabricIds:
						SetUpTaxonomies(tNode2, tJMaterial,
										0,  # metal
										0,  # specular
										0,  # specularTint
										tRoughness,  # roughness
										0,  # sheen
										0.5,  # sheenTint
										0,  # clearcoat
										0.03  # clearcoatRouth
										)
						# set color ramp
						if tNodeColorRamp != None:
							tNodeColorRamp.color_ramp.elements[1].position = 0.735909
							tNodeColorRamp.color_ramp.elements[0].position = 0.413636
					if tMetaMaterialId in tLeatherIds:
						SetUpTaxonomies(tNode2, tJMaterial,
										0,  # metal
										1,  # specular
										0,  # specularTint
										tRoughness,  # roughness
										0,  # sheen
										0.5,  # sheenTint
										0,  # clearcoat
										0.03  # clearcoatRouth
										)
						# set color ramp
						if tNodeColorRamp != None:
							tNodeColorRamp.color_ramp.elements[1].position = 1.0
							tNodeColorRamp.color_ramp.elements[0].position = 0.168182
					if tMetaMaterialId in tMetalIds:
						SetUpTaxonomies(tNode2, tJMaterial,
										1,  # metal
										0.567,  # specular
										0,  # specularTint
										tRoughness,  # roughness
										0,  # sheen
										0.567,  # sheenTint
										0,  # clearcoat
										0.03  # clearcoatRouth
										)
					if tMetaMaterialId in tPolyIds:
						SetUpTaxonomies(tNode2, tJMaterial,
										0,  # metal
										0.1,  # specular
										0,  # specularTint
										0.1,  # roughness
										0,  # sheen
										0.5,  # sheenTint
										0,  # clearcoat
										0.03  # clearcoatRouth
										)
					if tMetaMaterialId in tCeramIds:
						SetUpTaxonomies(tNode2, tJMaterial,
										0,  # metal
										1,  # specular
										0.5,  # specularTint
										0,  # roughness
										0,  # sheen
										0.592,  # sheenTint
										0,  # clearcoat
										0.03  # clearcoatRouth
										)
						Coating(tCoating, tNode2)
					if tMetaMaterialId in tGlassIds:
						# Use a glass instead of a pbr shader
						tNode2Glass = tMaterial.node_tree.nodes.new("ShaderNodeBsdfGlass")

						# convert rgbColor to hsv for setting v = 1 
						import colorsys

						hsvColor = colorsys.rgb_to_hsv(
							math.pow(tDiffuse[0], 2.2), #r gamma corrected
							math.pow(tDiffuse[1], 2.2), #g gamma corrected
							math.pow(tDiffuse[2],2.2)   #b gamma corrected
						)
						
						rgbColor = colorsys.hsv_to_rgb(
							hsvColor[0],  #h
							hsvColor[1],  #s
							1)            #v set v = 1 otherwise colored glass is not rendered proparlly

						tNode2Glass.inputs[0].default_value[0] = rgbColor[0]
						tNode2Glass.inputs[0].default_value[1] = rgbColor[1]
						tNode2Glass.inputs[0].default_value[2] = rgbColor[2]

						tNode2Glass.inputs[1].default_value = tRoughness

						tMaterialOutPutNode = tMaterial.node_tree.nodes.get("Material Output")
						# Unlink PBR and Image Texture
						tLinkOld = tMaterialOutPutNode.inputs[0].links[0]
						tMaterial.node_tree.links.remove(tLinkOld)

						tLinkGlass = tMaterial.node_tree.links.new(
							tNode2Glass.outputs[0], tMaterialOutPutNode.inputs[0])
						tUseBump = False
					if tMetaMaterialId in tVelvetIds:
						
						#create velvet node
						Velvet = loadScript('IGVelvet')
						tDeltaDiffuseImage = imagesLoad(folderPath, tDiffuseDeltaTexture)
						tDeltaRoughImage = imagesLoad(folderPath,tRoughnessDeltaTexture)
						Velvet.IGVelvet(tDeltaDiffuseImage, tDeltaRoughImage)

						tVelvet = tMaterial.node_tree.nodes.new(
							type="ShaderNodeGroup")
						tVelvet.name = "VelvetGroup"
						
						tVelvet.location = (-300,600)

						tVelvet.node_tree = bpy.data.node_groups["IG Velvet"]
						tVelvet.inputs["Diffuse"].default_value = (
							math.pow(tDiffuse[0], 2.2), math.pow(tDiffuse[1], 2.2), math.pow(tDiffuse[2], 2.2), 1) 
						
						if tRoughness:
							tVelvet.inputs["Roughness Factor"].default_value = tRoughness

						if tNodeTexCoord is None:
							tNodeTexCoord = tMaterial.node_tree.nodes.new("ShaderNodeTexCoord")
							tNodeTexCoord.location = (-1000, 300)

						#create diffuse delta mapping
						if tDiffuseDeltaMapping:
							tTranslationS = tDiffuseDeltaMapping["translationS"]
							tTranslationT = tDiffuseDeltaMapping["translationT"]
							tRotation = tDiffuseDeltaMapping["rotation"]
							tScaleS = 1/tDiffuseDeltaMapping["scaleS"]
							tScaleT = 1/tDiffuseDeltaMapping["scaleT"]
			 
							tNodeDiffuseMapping = tMaterial.node_tree.nodes.new(
								type="ShaderNodeGroup")
							tNodeDiffuseMapping.node_tree = bpy.data.node_groups["IG Material Mapping"]
							tNodeDiffuseMapping.name = "MappingDeltaDiffuse"
							tNodeDiffuseMapping.location = (-500, 440)
							tNodeDiffuseMapping.inputs["Rotation"].default_value[2] = math.pi/180 * tRotation
							tNodeDiffuseMapping.inputs["Scale"].default_value = (tScaleS, tScaleT, 1)
							tNodeDiffuseMapping.inputs["Translation"].default_value = (tTranslationS, tTranslationT, 0)
							tNodeDiffuseMapping.hide = True
							
							tMaterial.node_tree.links.new(tNodeDiffuseMapping.inputs["Vector"], tNodeTexCoord.outputs[2])
							tMaterial.node_tree.links.new(tVelvet.inputs["Mapping Diffuse"], tNodeDiffuseMapping.outputs[0])
						else:
							tMaterial.node_tree.links.new(tVelvet.inputs["Mapping Diffuse"], tNodeTexCoord.outputs[2])
						
						#create roughness delta mapping
						if tRoughnessDeltaMapping:
							tTranslationS = tRoughnessDeltaMapping["translationS"]
							tTranslationT = tRoughnessDeltaMapping["translationT"]
							tRotation = tRoughnessDeltaMapping["rotation"]
							tScaleS = 1/tRoughnessDeltaMapping["scaleS"]
							tScaleT = 1/tRoughnessDeltaMapping["scaleT"]
			 
							tNodeRoughnessMapping = tMaterial.node_tree.nodes.new(
								type="ShaderNodeGroup")
							tNodeRoughnessMapping.node_tree = bpy.data.node_groups["IG Material Mapping"]
							tNodeRoughnessMapping.name = "MappingDeltaRough"
							tNodeRoughnessMapping.location = (-500, 400)
							tNodeRoughnessMapping.inputs["Rotation"].default_value[2] = math.pi/180 * tRotation
							tNodeRoughnessMapping.inputs["Scale"].default_value = (tScaleS, tScaleT, 1)
							tNodeRoughnessMapping.inputs["Translation"].default_value = (tTranslationS, tTranslationT, 0)
							tNodeRoughnessMapping.hide = True

							tMaterial.node_tree.links.new(tNodeRoughnessMapping.inputs["Vector"], tNodeTexCoord.outputs[2])
							tMaterial.node_tree.links.new(tVelvet.inputs["Mapping Roughness"], tNodeRoughnessMapping.outputs[0])
						else:
							tMaterial.node_tree.links.new(tVelvet.inputs["Mapping Roughness"], tNodeTexCoord.outputs[2])
					

						# Link Specular, Roughness to PBR
						tMaterial.node_tree.links.new(tNode2.inputs[5], tVelvet.outputs["Specular"])

						if "roughness" in tJMaterial:
							tNodeRoughTex = tMaterial.node_tree.nodes.get("Image Rough Texture")
							# Unlink roughness tex from pbr
							tLinkOld = tNode2.inputs[7].links[0]
							tMaterial.node_tree.links.remove(tLinkOld)
							
							tLinkVelvetColorTex = tMaterial.node_tree.links.new(
								tNodeRoughTex.outputs[0], tVelvet.inputs["Roughness Factor"])
						else:
							if tNodeColorRamp is not None:
								# Unlink color ramp from pbr
								tLinkOld = tNode2.inputs[7].links[0]
								tMaterial.node_tree.links.remove(tLinkOld)

								tLinkVelvetColorRamp = tMaterial.node_tree.links.new(
								tNodeColorRamp.outputs[0], tVelvet.inputs["Roughness Factor"])


						tMaterial.node_tree.links.new(tNode2.inputs[7], tVelvet.outputs["Roughness"])
						



						if tHasTexture:
							#relink Diffuse image and Velvet shader
							tLinkOld = tNode2.inputs[0].links[0]
							tMaterial.node_tree.links.remove(tLinkOld)
							tMaterial.node_tree.links.new(tVelvet.inputs["Diffuse"], tNodeImageTex.outputs[0])
							tMaterial.node_tree.links.new(tNode2.inputs[0], tVelvet.outputs["Base Color"])
						else:
							tMaterial.node_tree.links.new(tNode2.inputs[0], tVelvet.outputs["Base Color"])
						
				#  if Bump
				CreateBumpSetUp(tNode2, tMaterial.node_tree.nodes.get(
					"Image Texture"),
					tMaterial.node_tree.nodes.get("Normal Map"), tMaterial, tUseBump, BumpStrength)
				tUseBump = False   

	def importCyclesMaterial(scene, folderPath, environment):
		bpy.context.scene.render.engine = "CYCLES"
		# return
		importNodeMaterial(scene, folderPath, environment)
	# importCyclesMaterial End

	def importBlenderMaterial(scene, folderPath, enviornment):
		print("Warning", "Blender internal render enginge has been removed since 2.80. Use Eevee instead!")
		importEeveeMaterial(scene, folderPath, enviornment)
	# importBlenderMaterial End

	def importEeveeMaterial(scene, folderPath, enviornment):
		print("Log", "This is used instead of blender internal render engine")
		bpy.context.scene.render.engine = "BLENDER_EEVEE"
		# return
		importNodeMaterial(scene, folderPath, environment)

	if ("Renderer" in environment):
		if(environment["Renderer"] == "Cycles"):
			# tNormalMapValue =
			importCyclesMaterial(scene, folderPath, environment)
			# return tNormalMapValue
		elif(environment["Renderer"] == "Blender"):
			# tNormalMapValue =
			importBlenderMaterial(scene, folderPath, environment)
			# return tNormalMapValue
		elif(environment["Renderer"] == "Eevee"):
			# tNormalMapValue =
			importEeveeMaterial(scene, folderPath, environment)
			# return tNormalMapValue
	else:
		# use as fallback
		importCyclesMaterial(scene, folderPath, environment)
		# tNormalMapValue = importCyclesMaterial(scene, folderPath, environment)



def importOCNode(node, hierarchy, materialCategories, geometries, folderpath, environment, scene, position, rotation):

	def getTransform(node, type, default):
		return [node["transform"][type].get("x", default),
			 -node["transform"][type].get("z", default),
			 node["transform"][type].get("y", default) if type == "position" 
			 else node["transform"][type].get("y", default)]

	def getRotation(node):
		return [node["transform"]["rotation"].get("x", 0),
			 -node["transform"]["rotation"].get("z", 0),
			 node["transform"]["rotation"].get("y", 0),
			  node["transform"]["rotation"].get("w", 1)]

	def getScale(node):
		return [node["transform"]["scale"].get("x", 1),
			node["transform"]["scale"].get("z", 1),
			node["transform"]["scale"].get("y", 1)]


	def setUpTransfromation(node):
		tPosition =[0,0,0]
		tRotation = [0,0,0,1] #(x,y,z,w)
		tScale = [1,1,1]

		tUseQuaternion = True
		
		tTransform = node.get("transform",{})

		if "position" in tTransform:
			tPosition = getTransform(node,"position", 0)
		if "rotation" in tTransform:
			tRotation = getRotation(node)
		if "scale" in tTransform:
			tScale = getScale(node)
		setUpQuaternion(rotation = tRotation, position = tPosition)
		bpy.context.object.scale = tScale

	def setUpQuaternion(rotation, position):
			if len(position) > 0:
				pX = position[0]
				pY = position[1]
				pZ = position[2]

			bpy.ops.object.empty_add(type="PLAIN_AXES", radius=1, location=(
				pX, pY, pZ))
			bpy.context.object.rotation_mode = "QUATERNION"
			
			bpy.context.object.rotation_quaternion[0] = rotation[3] # w
			bpy.context.object.rotation_quaternion[1] = rotation[0] # x
			bpy.context.object.rotation_quaternion[2] = rotation[1] # y
			bpy.context.object.rotation_quaternion[3] = rotation[2] # z
			bpy.context.object.rotation_mode = "XYZ"


	def buildPathName(selectedObject, objects, hierarchy):
		componentPath = objects["path"]
		selectedObject.name = "P" + str(hierarchy) + "_" + componentPath

		return "P" + str(hierarchy) + "_" + componentPath

	#import geometry obj/ctm/glTF/glb/fbx
	def importGeometry(node, geometries, folderPath):
		tGeometry = node["geometry"]
		tmesh = None

		# check if geometry is in big list of geometries
		if tGeometry in geometries: 
			currentGeometry = geometries[tGeometry]		
			if "ig" in currentGeometry:
				meshes = currentGeometry["ig"]
				tmesh = meshes.get("mesh", None)
			else:
				print ("ERROR", "No mesh data available")

			if tmesh is not None:
				tFileImport = buildAbsPath(folderPath, tmesh)
				
				# setHighQuali = False
				bpy.ops.object.select_all(action="DESELECT")

				fileformat = ""
				if os.path.exists(tFileImport):
					if tFileImport.endswith("obj"):
						bpy.ops.import_scene.obj(
							filepath=tFileImport, split_mode="OFF")
						fileformat = "obj"
					elif tFileImport.endswith("ctm"):
						bpy.ops.import_scene.ctm(filepath=tFileImport)
						fileformat = "ctm"
					elif tFileImport.endswith("gltf") or tFileImport.endswith("glb"):
						bpy.ops.import_scene.gltf(filepath=tFileImport)
						fileformat = "glb/gltf"
						#select gltf because imported dosen't for 2.9
						activeGlTF=bpy.context.view_layer.objects.active.name
						bpy.data.objects[activeGlTF].select_set(True)

						bpy.ops.object.collection_link(collection='Object')
						bpy.data.scenes['Scene'].collection.objects.unlink(bpy.context.view_layer.objects.active)

					elif tFileImport.endswith("fbx"):
						bpy.ops.import_scene.fbx(filepath=tFileImport)
						# setHighQuali = True
						fileformat = "fbx"
					else:
						print("ERROR", "File not found:", tFileImport)

					tImportedGeometry = bpy.context.selected_objects[0]

					if len(tImportedGeometry.data.uv_layers) > 0:
						tImportedGeometry.data.uv_layers[0].name = "diffuse_map"
					else:
						print("WARNING", "No uv sets available for Geometry", tGeometry)

					bpy.context.view_layer.objects.active = tImportedGeometry

					# remove double vertices
					#change area
					tArea = bpy.context.area
					print("Old Area", tArea.type)
					tOldArea = "None"

					if bpy.app.background:
						area = bpy.context.screen.areas[0]
						tArea = area
						tOldArea = area.type
					else:
						for window in bpy.context.window_manager.windows:
							for area in window.screen.areas:
								tArea = area 
								print("Areatype", area.ui_type)
								tOldArea = area.ui_type
							if area.ui_type == 'VIEW_3D' or area.ui_type == 'IMAGE_EDITOR':
								tOldArea == 'VIEW_3D'
								break

					tArea.ui_type = 'VIEW_3D'

					#remove doubles
					if bpy.ops.object.mode_set.poll():
						# bpy.ops.object.mode_set_with_submode({'area': tArea},mode='EDIT', mesh_select_mode={"FACE"})
						bpy.ops.object.mode_set(mode='EDIT')
					bpy.ops.mesh.remove_doubles({'area': tArea})
					if bpy.ops.object.mode_set.poll():
						bpy.ops.object.mode_set(mode='OBJECT')
					for area in bpy.context.screen.areas:
							if area.ui_type == 'VIEW_3D' or area.ui_type == 'IMAGE_EDITOR':
								area.ui_type == tOldArea
								break
					# tArea.type = tOldArea

					print("Back Done Area Type", tOldArea, "->", tArea.type)

					bpy.ops.object.shade_smooth()
					
					
					tImportedGeometry.name = tGeometry
					componentName = tImportedGeometry.name

					bpy.ops.object.transform_apply(
						location=False, rotation=True, scale=False)
					bpy.ops.object.select_all(action="DESELECT")
					bpy.data.objects[componentName].select_set(True)
					bpy.context.view_layer.objects.active = bpy.data.objects[componentName]

					# #Write logging information
					# tris=len(bpy.context.object.data.polygons.values())
					# volume = bpy.context.object.dimensions[0]* bpy.context.object.dimensions[1] * bpy.context.object.dimensions[2]
					# logging.info(f"Geometry: {componentName}")
					# logging.info(f"File format: {fileformat}")
					# logging.info(f"Triangles: {tris}")
					# logging.info(f"Dimension (Blender) X: {bpy.context.object.dimensions[0]} Y: {bpy.context.object.dimensions[1]} Z: {bpy.context.object.dimensions[2]}")
					# logging.info(f"Volume: {volume} m³")
					# if volume == 0:
					# 	logging.info("Tris/m³: 0")
					# else:
					# 	logging.info(f"Tris/m³: {tris/volume}")
					

					# tSubdif = False
					# if setHighQuali:
					# 	if tris/volume < 17000:
					# 		bpy.ops.object.modifier_add(type='SUBSURF')
					# 		bpy.context.object.modifiers['Subdivision'].levels = 2
					# 		bpy.context.object.modifiers['Subdivision'].render_levels = 2
					# 		tSubdif = True
					
					# setHighQuali = False
					# logging.info(f"SubDiv: {tSubdif}")
					# logging.info("")

					return componentName, True
				else:
					print("ERROR", "Cannot resolve geometry. Path does not exist!", tGeometry)
					return "", False
			else: 
				print("INFO", "No mesh available for", currentGeometry)
				return "", False
		else:
			print("ERROR", "Cannot resolve geometry", tGeometry)
			return "", False
	def setGeoMapping(geometry, mapping):

		def calculateTransformation(transMatrix):

			bm = bmesh.new()
			bm.from_mesh(obj.data)

			uv_layer = bm.loops.layers.uv.verify()#bm.loops.layers.uv['diffuse_map'].verify()

			for f in bm.faces:
				for l in f.loops:
					loop_uv = l[uv_layer]
					uv4x4 = mathutils.Vector((loop_uv.uv[0], loop_uv.uv[1], 0, 1))

					uv4x4 = uv4x4 @ TransformMatrix

					loop_uv.uv[0] = uv4x4[0]
					loop_uv.uv[1] = uv4x4[1]

			bm.to_mesh(obj.data)
			bm.free()
		# make geometry active
		bpy.data.objects[tComponentName].select_set(True)
		bpy.context.view_layer.objects.active = bpy.data.objects[tComponentName]
		obj = bpy.context.view_layer.objects.active

		# build transformation matrix
		tScaleS =1/mapping.get("scaleS",1)
		tScaleT = 1/mapping.get("scaleT",1)
	
		tTranslationS = mapping.get("translationS",0)
		tTranslationT = mapping.get("translationT",0)

		tRotation = mapping.get("rotation",0)

		TransMatrix = mathutils.Matrix.Translation((tTranslationS, tTranslationT, 0))
		TransMatrix.transpose()
		ScaleMatrix = mathutils.Matrix.Diagonal((tScaleS, tScaleT, 1.0, 1.0))
		RotMatrix = mathutils.Matrix.Rotation(math.radians(tRotation), 4, 'Z')
		RotMatrix.transpose()

		TransformMatrix = ScaleMatrix@ TransMatrix @RotMatrix

		calculateTransformation(TransformMatrix)

	#read out geometry, its hirarchical positon and transforms from node
	setUpTransfromation(node)
	tSelectedObject = bpy.context.object
	tComponentPath = buildPathName(tSelectedObject, node, hierarchy)

	# check for parent
	if (tComponentPath == "P" + str(hierarchy) +"_."):
		tParentPath = "."
		if len(position) > 0:
			tSelectedObject.location[0]=position["x"]
			tSelectedObject.location[1]=-position["z"]
			tSelectedObject.location[2]=position["y"]
		if len(rotation)> 0:
			tSelectedObject.rotation_mode = "QUATERNION"
			tSelectedObject.rotation_quaternion[0] = rotation["w"]
			tSelectedObject.rotation_quaternion[1] = rotation["x"]
			tSelectedObject.rotation_quaternion[2] = -rotation["z"]
			tSelectedObject.rotation_quaternion[3] = rotation["y"]
			tSelectedObject.rotation_mode = "XYZ"
	elif ("." in tComponentPath):
		tParentPath = tComponentPath[0:tComponentPath.rfind(".")]
	else:
		tParentPath = "P" + str(hierarchy) + "_."

	tHasParent = False
	if (tParentPath != ""):
		tHasParent = tParentPath in bpy.data.objects

	tHasGeometry = False

	if "geometry" in node:
		ImportedGeometriesProp = importGeometry(
			node, geometries, folderpath)
		tHasGeometry = ImportedGeometriesProp[1]
		tComponentName = ImportedGeometriesProp[0]
		
	tHasMaterial = False
	if "materialCategory" in node:
		tCategory = node["materialCategory"]
		tHasMaterial = False

		if tCategory[:1] == "@":
			# implicit category
			tMaterial = tCategory[1:]
			tHasMaterial = True
		elif tCategory in materialCategories:
			# explicit category
			tMaterial = materialCategories[tCategory]
			tHasMaterial = True
		else:
			print("ERROR", "Cannot resolve Material Category", tCategory)
	
	if "mapping" in node:
		# create mapping for geometry
		tMapping = node["mapping"]
		setGeoMapping(tComponentName, tMapping)


	if tHasGeometry:
		bpy.ops.object.select_all(action="DESELECT")
		bpy.data.objects[tComponentName].select_set(True)
		bpy.data.objects[tComponentPath].select_set(True)
		bpy.context.view_layer.objects.active = bpy.data.objects[tComponentPath]
		bpy.ops.object.parent_set(type="OBJECT", keep_transform=True)
		bpy.ops.object.parent_clear(type="CLEAR_INVERSE")

		if (tHasMaterial):
			bpy.data.objects[tComponentName].select_set(True)
			bpy.context.view_layer.objects.active = bpy.data.objects[tComponentName]

			# Delete all native imported materials from object to avoid erros in material rendering:
			bpy.context.active_object.data.materials.clear()

			if bpy.context.active_object.data.materials:
				
				bpy.context.active_object.data.materials[0] = bpy.data.materials.get(
					tMaterial)
				# assignUVMap(bpy.context.active_object.data.materials, bpy.context.active_object.data.name, environment, scene)
			else:
				bpy.context.active_object.data.materials.append(
					bpy.data.materials.get(tMaterial))
				# assignUVMap(bpy.context.active_object.data.materials, bpy.context.active_object.data.name, environment, scene)

	bpy.ops.object.select_all(action="DESELECT")
	bpy.data.objects[tComponentPath].select_set(True)

	# Create parent-child relationship:
	if (tParentPath != ""):
		bpy.data.objects[tParentPath].select_set(True)

		bpy.context.view_layer.objects.active = bpy.data.objects[tParentPath]
		bpy.ops.object.parent_set(type="OBJECT", keep_transform=False)
		bpy.ops.object.parent_clear(type="CLEAR_INVERSE")
 # End importOCNode


def addNormalsGeometry(scene, geometry ,normalMap, folderPath,  environment, normalMapStrength = 1):

	def importNodesNormalsGeometry(scene, folderPath, texturePath, blenderMaterial, environment, normalMapStrength = 1):
		normalMapValue = 0.2
		# take this if it is a shared normal map
		if pathlib.Path(folderPath + texturePath).is_file():
			tObj = bpy.context.view_layer.objects.active
			tTextureImage = imagesLoad(folderPath, texturePath)

			pbrNode = blenderMaterial.node_tree.nodes.get("Principled BSDF")

			tNode6GeoNormal = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeTexImage")
			tNode6GeoNormal.location = (-1000, 0)
			tNode6GeoNormal.image = tTextureImage
			tNode6GeoNormal.image.colorspace_settings.name = 'Non-Color'

			tNodeUVMap = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeUVMap")
			tNodeUVMap.location = (-1800, 0)
			tNodeUVMap.uv_map = tObj.data.uv_layers[1].name

			Link1 = blenderMaterial.node_tree.links.new(
				tNodeUVMap.outputs[0], tNode6GeoNormal.inputs[0])

			tNodeNormalMapCombine = blenderMaterial.node_tree.nodes.get(
				"NormalMapCombineGroup")
			if tNodeNormalMapCombine != None:
				LinkImageCombine = blenderMaterial.node_tree.links.new(
					tNode6GeoNormal.outputs[0], tNodeNormalMapCombine.inputs[0])
			else:
				tNodeNormalMap = blenderMaterial.node_tree.nodes.new(type = "ShaderNodeNormalMap")
				tNodeNormalMap.location = (-500, 0)
				tNodeNormalMap.uv_map = tObj.data.uv_layers[1].name

				tNodeNormalMap.inputs[0].default_value=normalMapStrength #strength default 1 reference 48
				
				Link2 = blenderMaterial.node_tree.links.new(
					tNode6GeoNormal.outputs[0], tNodeNormalMap.inputs[1]
				)
				tNodeBump = blenderMaterial.node_tree.nodes.get("Bump")
				if tNodeBump != None:
					Link3 = blenderMaterial.node_tree.links.new(tNodeNormalMap.outputs["Normal"], tNodeBump.inputs["Normal"])
				else:
					Link4 = blenderMaterial.node_tree.links.new(tNodeNormalMap.outputs["Normal"], pbrNode.inputs[20])

	tNormal = normalMap

	tListMeshes = [tObj for tObj in bpy.data.objects if tObj.type ==
				   'MESH' and tObj.name.startswith("z") == False]

	tObjectsNormalsList = []

	for tObj in tListMeshes:
		tObjectName = tObj.name.split(".geo", 1)[0]
		if len(tObjectName.split(".", 3)) > 3:
			tObjectName = tObjectName[:-4]
		
		tNormalGeometry = tObjectName.split("/")
		
		if tNormalGeometry[len(tNormalGeometry)-1].split('.')[-1] == geometry.split('.')[-1] :
			tObjectsNormalsList.append(tObj)

	print("-------------------------")
	print('\n'.join([str(tObj) for tObj in tObjectsNormalsList]))

	for tObj in tObjectsNormalsList:

		bpy.ops.object.select_all(action="DESELECT")
		bpy.data.objects[tObj.name].select_set(True)
		bpy.context.view_layer.objects.active = bpy.data.objects[tObj.name]

		if len(bpy.context.active_object.data.materials) > 0:

			tMaterialTemp = bpy.context.active_object.data.materials[0]

			tMaterialNormal = tMaterialTemp.copy()

			bpy.context.active_object.data.materials[0] = tMaterialNormal

			tObjectName = tObj.data.name.split(".geo", 1)[0]

			if len(tObjectName.split(".", 3)) > 3:
				tObjectName = tObjectName[:-4]

			if len(tObjectName.split("/")) > 1:
				tObjectName = tObjectName.split("/")[len(tObjectName.split("/"))-1]

			tTexturePath = tNormal

			importNodesNormalsGeometry(
				scene, folderPath, tTexturePath, tMaterialNormal, environment, normalMapStrength)
# End addNormalsGeometry
