# OpenConfiguration Blender Importer

OpenConfiguration a.k.a. OC (https://docs.openconfiguration.org) is an exchange format for 3D data with special focus on CPQ/3D commerce product representations.

This Importer a.k.a. OC Importer implements the direct import of OC scenes with local asset references into blender.

## How to:

Install the OC Importer add-on for blender.

Inside Files/Importers/OC navigate to a folder that contains an OC scene file (scene.json). Note, in case you got an OC Zip, please unpack it first. 

OC zips can be downloaded from the ig.Creator pages Products/Graphical/Configurator and Products/Graphics/Planner, for instance. Also some configurators listed on the OC Page, provide download of OC Zips.

## How to create an add-on package from scratch manually?

Copy the corresponding OC Importer version (typically the latest blender version) onto your desktop.

Rename the folder OC-Importer.

From the Tools.Blender repo Importers folder, copy the fitting Shared folder version into to OC-Importer folder on you desktop and rename the version number to Shared.

Zip the OC-Importer folder.

This is an example, how the manually created OC-Importer folder structure looks before zipping:

```tex
- OC-Importer
    + Shared
    - __init__.py
    - oc_import.py
```

Note: Make sure, OC Importer and Shared use the same versions. Otherwise package will not work.

## How to create an add-on package from scratch automatically?

Run the powershell script inside the OC-Importer folder.

It will pack a zip ready to install for blender.

## Known Issues

- Currently the OC Importer does not support OC Zips directly. You have to unzip them yourself.
- Blender only can handle object names with max. 63 characters. In case an OC scene is using node or geometry names with more characters, this will break the import.
- The OC Importer does not support deformation.json files
- The OC Importer does not restore animations

## History

**2022-04-19**

- initial version

## License

See OpenConfiguration License: https://raw.githubusercontent.com/intelligentgraphics/OpenConfiguration/master/LICENSE.txt

## Copyright

Copyright (C) 2020 - 2022 intelligentgraphics AG. All Rights Reserved.