import bpy
import datetime
import math

global version
version = 1.0


def IGVelvet(deltaDiffuse=None, deltaRoughness=None):
	print("IGVelvet Blender NodeCreator", version, ". Copyright (C) 2020 -",
		  datetime.datetime.now().year, "intelligentgraphics AG. All Rights Reserved.")

	# create a group
	igv_group = bpy.data.node_groups.new(
		'IG Velvet', 'ShaderNodeTree')

	# create group inputs
	group_inputs = igv_group.nodes.new('NodeGroupInput')
	group_inputs.location = (-500, -1000)

	igv_group.inputs.new('NodeSocketColor', 'Diffuse')
	igv_group.inputs.new('NodeSocketVector', 'Mapping Diffuse')
	igv_group.inputs.new('NodeSocketFloat', 'Diffuse Factor')
	igv_group.inputs.new('NodeSocketVector', 'Mapping Roughness')
	igv_group.inputs.new('NodeSocketFloat', 'Roughness Factor')
	igv_group.inputs.new('NodeSocketFloat', 'Specular Factor')

	igv_group.inputs['Diffuse Factor'].default_value = math.pow(2, 2.2)
	igv_group.inputs['Specular Factor'].default_value = 5
	igv_group.inputs['Roughness Factor'].default_value = 2

	# create group outputs
	group_outputs = igv_group.nodes.new('NodeGroupOutput')
	group_outputs.location = (2500, -600)

	igv_group.outputs.new('NodeSocketColor', 'Base Color')
	igv_group.outputs.new('NodeSocketFloat', 'Specular')
	igv_group.outputs.new('NodeSocketFloat', 'Roughness')

	# create nodes

	## diffuse part ##

	frameDiffuse = igv_group.nodes.new('NodeFrame')
	frameDiffuse.label = "Diffuse"
	frameDiffuse.label_size = 64

	diffuse_N1 = igv_group.nodes.new('ShaderNodeTexImage')
	diffuse_N1.location = (-50, 150)
	if deltaDiffuse is not None:
		diffuse_N1.image = deltaDiffuse

	diffuse_N1.parent = frameDiffuse

	diffuse_N3 = igv_group.nodes.new('ShaderNodeMath')
	diffuse_N3.location = (350, 100)
	diffuse_N3.operation = 'MULTIPLY'

	diffuse_N4 = igv_group.nodes.new('ShaderNodeSeparateRGB')
	diffuse_N4.location = (600, 100)

	diffuse_N5 = igv_group.nodes.new('ShaderNodeSeparateRGB')
	diffuse_N5.location = (600, -300)

	diffuse_N6 = igv_group.nodes.new('ShaderNodeMath')
	diffuse_N6.location = (1000, 100)
	diffuse_N6.operation = 'MULTIPLY'

	diffuse_N7 = igv_group.nodes.new('ShaderNodeMath')
	diffuse_N7.location = (1000, -100)
	diffuse_N7.operation = 'MULTIPLY'

	diffuse_N8 = igv_group.nodes.new('ShaderNodeMath')
	diffuse_N8.location = (1000, -300)
	diffuse_N8.operation = 'MULTIPLY'

	diffuse_N9 = igv_group.nodes.new('ShaderNodeCombineRGB')
	diffuse_N9.location = (1300, -40)

	# put all into the diffuse frame
	diffuse_N1.parent = frameDiffuse
	diffuse_N3.parent = frameDiffuse
	diffuse_N4.parent = frameDiffuse
	diffuse_N5.parent = frameDiffuse
	diffuse_N6.parent = frameDiffuse
	diffuse_N7.parent = frameDiffuse
	diffuse_N8.parent = frameDiffuse
	diffuse_N9.parent = frameDiffuse

	## specular part ##

	frameSpecular = igv_group.nodes.new('NodeFrame')
	frameSpecular.label = "Specular"
	frameSpecular.label_size = 64

	PointOfView(deltaRoughness)
	specular_N1 = igv_group.nodes.new(type='ShaderNodeGroup')
	specular_N1.node_tree = bpy.data.node_groups["IG POI"]
	specular_N1.location = (1000, -600)
	specular_N1.inputs['Factor'].default_value = 15
	specular_N1.inputs['Threshold'].default_value = 1.9

	# spec factor?
	specular_N2 = igv_group.nodes.new('ShaderNodeMath')
	specular_N2.location = (1000, -600)
	specular_N2.operation = 'MULTIPLY'

	# put all into the specular frame
	specular_N1.parent = frameSpecular
	specular_N2.parent = frameSpecular

	## roughness part ##

	frameRoughness = igv_group.nodes.new('NodeFrame')
	frameRoughness.label = "Roughness"
	frameRoughness.label_size = 64

	PointOfViewRoughness(deltaRoughness)
	roughness_N1 = igv_group.nodes.new(type='ShaderNodeGroup')
	roughness_N1.node_tree = bpy.data.node_groups["IG POI Rough"]
	roughness_N1.location = (1500, -1000)
	roughness_N1.inputs['Factor'].default_value = 4.2
	roughness_N1.inputs['Threshold'].default_value = 0.39

	roughness_N3 = igv_group.nodes.new('ShaderNodeMath')
	roughness_N3.location = (1800, -1000)
	roughness_N3.operation = 'MULTIPLY'
	roughness_N3.inputs[1].default_value = 5.0

	# put all into the roughness frame

	roughness_N1.parent = frameRoughness
	roughness_N3.parent = frameRoughness

	# link nodes together

	## diffuse part ##

	igv_group.links.new(
		diffuse_N1.inputs[0], group_inputs.outputs['Mapping Diffuse'])
	igv_group.links.new(diffuse_N3.inputs[0], diffuse_N1.outputs[0])

	igv_group.links.new(
		diffuse_N3.inputs[1], group_inputs.outputs['Diffuse Factor'])

	igv_group.links.new(diffuse_N4.inputs[0], diffuse_N3.outputs[0])

	# to do remove rgb node?
	igv_group.links.new(diffuse_N5.inputs[0], group_inputs.outputs['Diffuse'])

	# multiply rgb
	igv_group.links.new(diffuse_N6.inputs[0], diffuse_N4.outputs[0])
	igv_group.links.new(diffuse_N6.inputs[1], diffuse_N5.outputs[0])

	igv_group.links.new(diffuse_N7.inputs[0], diffuse_N4.outputs[1])
	igv_group.links.new(diffuse_N7.inputs[1], diffuse_N5.outputs[1])

	igv_group.links.new(diffuse_N8.inputs[0], diffuse_N4.outputs[2])
	igv_group.links.new(diffuse_N8.inputs[1], diffuse_N5.outputs[2])

	# combine
	igv_group.links.new(diffuse_N9.inputs[0], diffuse_N6.outputs[0])
	igv_group.links.new(diffuse_N9.inputs[1], diffuse_N7.outputs[0])
	igv_group.links.new(diffuse_N9.inputs[2], diffuse_N8.outputs[0])

	# link to output
	igv_group.links.new(
		group_outputs.inputs['Base Color'], diffuse_N9.outputs[0])

	## specular part ##

	igv_group.links.new(
		specular_N1.inputs['Mapping Roughness'], group_inputs.outputs['Mapping Roughness'])
	# igv_group.links.new(
	#	 specular_N1.inputs[0], group_inputs.outputs['Specular Factor'])

	# linkt to output
	igv_group.links.new(
		group_outputs.inputs['Specular'], specular_N1.outputs[0])

	## roughness part ##

	igv_group.links.new(
		roughness_N1.inputs['Mapping Roughness'], group_inputs.outputs['Mapping Roughness'])
	igv_group.links.new(group_inputs.outputs['Roughness Factor'], roughness_N1.inputs['Roughness Factor'])
	igv_group.links.new(roughness_N3.inputs[0], roughness_N1.outputs[0])
	igv_group.links.new(
		group_outputs.inputs['Roughness'], roughness_N3.outputs[0])

def PointOfView(deltaRoughness):
	# create a group
	igv_group = bpy.data.node_groups.new(
		'IG POI', 'ShaderNodeTree')

	# create group inputs
	group_inputs = igv_group.nodes.new('NodeGroupInput')
	group_inputs.location = (-500, 0)

	igv_group.inputs.new('NodeSocketVector', 'Mapping Roughness')
	igv_group.inputs.new('NodeSocketFloat', 'Factor')
	igv_group.inputs.new('NodeSocketFloat', 'Threshold')

	# create group outputs
	group_outputs = igv_group.nodes.new('NodeGroupOutput')
	group_outputs.location = (2500, 0)

	igv_group.outputs.new('NodeSocketFloat', 'Value')

	# creat nodes
	framePOI = igv_group.nodes.new('NodeFrame')
	framePOI.label = "POV"
	framePOI.label_size = 20

	pov_N1 = igv_group.nodes.new('ShaderNodeNewGeometry')
	pov_N1.location = (300, 0)

	pov_N2 = igv_group.nodes.new('ShaderNodeVectorMath')
	pov_N2.location = (600, 0)
	pov_N2.operation = 'DOT_PRODUCT'

	pov_N3 = igv_group.nodes.new('ShaderNodeMath')
	pov_N3.location = (900, 0)
	pov_N3.operation = 'ARCCOSINE'
	pov_N3.use_clamp = True

	pov_N1.parent = framePOI
	pov_N2.parent = framePOI
	pov_N3.parent = framePOI

	frameNorm = igv_group.nodes.new('NodeFrame')
	frameNorm.label = "Normalize"
	frameNorm.label_size = 20

	pov_N4 = igv_group.nodes.new('ShaderNodeMath')
	pov_N4.location = (1200, 0)
	pov_N4.operation = 'DIVIDE'
	pov_N4.inputs[1].default_value = math.pi
	pov_N4.use_clamp = True

	pov_N4.parent = frameNorm

	pov_N5 = igv_group.nodes.new('ShaderNodeTexImage')
	pov_N5.location = (1200, -200)
	# roughness_N1.image = deltaRoughness
	if deltaRoughness is not None:
		pov_N5.image = deltaRoughness
		pov_N5.image.colorspace_settings.name = 'Non-Color'

	pov_N6 = igv_group.nodes.new('ShaderNodeMath')
	pov_N6.location = (1500, 0)
	pov_N6.operation = 'MULTIPLY'
	pov_N6.use_clamp = True

	frameFineTune = igv_group.nodes.new('NodeFrame')
	frameFineTune.label = "Fine Tuning"
	frameFineTune.label_size = 20

	pov_N7 = igv_group.nodes.new('ShaderNodeMath')
	pov_N7.location = (1800, 0)
	pov_N7.operation = 'MULTIPLY'
	pov_N7.use_clamp = True

	pov_N8 = igv_group.nodes.new('ShaderNodeMath')
	pov_N8.location = (2100, 0)
	pov_N8.operation = 'GREATER_THAN'
	pov_N8.use_clamp = True

	pov_N7.parent = frameFineTune
	pov_N8.parent = frameFineTune

	# link nodes
	igv_group.links.new(pov_N1.outputs[1], pov_N2.inputs[0])
	igv_group.links.new(pov_N1.outputs[4], pov_N2.inputs[1])

	igv_group.links.new(pov_N2.outputs['Value'], pov_N3.inputs['Value'])

	igv_group.links.new(pov_N3.outputs[0], pov_N4.inputs[0])

	igv_group.links.new(
		group_inputs.outputs['Mapping Roughness'], pov_N5.inputs[0])

	igv_group.links.new(pov_N4.outputs[0], pov_N6.inputs[0])
	igv_group.links.new(pov_N5.outputs[0], pov_N6.inputs[1])

	igv_group.links.new(pov_N6.outputs[0], pov_N7.inputs[0])
	igv_group.links.new(group_inputs.outputs['Factor'], pov_N7.inputs[1])

	igv_group.links.new(pov_N7.outputs[0], pov_N8.inputs[0])
	igv_group.links.new(group_inputs.outputs['Threshold'], pov_N8.inputs[1])

	igv_group.links.new(pov_N8.outputs[0], group_outputs.inputs['Value'])


def PointOfViewRoughness(deltaRoughness):
	# create a group
	igv_group = bpy.data.node_groups.new(
		'IG POI Rough', 'ShaderNodeTree')

	# create group inputs
	group_inputs = igv_group.nodes.new('NodeGroupInput')
	group_inputs.location = (-500, 0)

	igv_group.inputs.new('NodeSocketVector', 'Mapping Roughness')
	igv_group.inputs.new('NodeSocketFloat', 'Factor')
	igv_group.inputs.new('NodeSocketFloat', 'Threshold')
	igv_group.inputs.new('NodeSocketFloat', 'Roughness Factor')

	# create group outputs
	group_outputs = igv_group.nodes.new('NodeGroupOutput')
	group_outputs.location = (2500, 0)

	igv_group.outputs.new('NodeSocketFloat', 'Value')

	# creat nodes
	framePOI = igv_group.nodes.new('NodeFrame')
	framePOI.label = "POV"
	framePOI.label_size = 20

	pov_N1 = igv_group.nodes.new('ShaderNodeNewGeometry')
	pov_N1.location = (300, 0)

	pov_N2 = igv_group.nodes.new('ShaderNodeVectorMath')
	pov_N2.location = (600, 0)
	pov_N2.operation = 'DOT_PRODUCT'

	pov_N3 = igv_group.nodes.new('ShaderNodeMath')
	pov_N3.location = (900, 0)
	pov_N3.operation = 'ARCCOSINE'
	pov_N3.use_clamp = True

	pov_N1.parent = framePOI
	pov_N2.parent = framePOI
	pov_N3.parent = framePOI

	frameNorm = igv_group.nodes.new('NodeFrame')
	frameNorm.label = "Normalize"
	frameNorm.label_size = 20

	pov_N4 = igv_group.nodes.new('ShaderNodeMath')
	pov_N4.location = (1200, 0)
	pov_N4.operation = 'DIVIDE'
	pov_N4.inputs[1].default_value = math.pi
	pov_N4.use_clamp = True

	pov_N4.parent = frameNorm

	pov_N5 = igv_group.nodes.new('ShaderNodeTexImage')
	pov_N5.location = (1200, -200)
	if deltaRoughness is not None:
		pov_N5.image = deltaRoughness
		pov_N5.image.colorspace_settings.name = 'Non-Color'

	pov_N51 = igv_group.nodes.new('ShaderNodeMath')
	pov_N51.location = (1400, -200)
	pov_N51.operation = 'MULTIPLY'
	pov_N51.use_clamp = True

	pov_N6 = igv_group.nodes.new('ShaderNodeMath')
	pov_N6.location = (1500, 0)
	pov_N6.operation = 'MULTIPLY'
	pov_N6.use_clamp = True

	frameFineTune = igv_group.nodes.new('NodeFrame')
	frameFineTune.label = "Fine Tuning"
	frameFineTune.label_size = 20

	pov_N7 = igv_group.nodes.new('ShaderNodeMath')
	pov_N7.location = (1800, 0)
	pov_N7.operation = 'MULTIPLY'
	pov_N7.use_clamp = True

	pov_N8 = igv_group.nodes.new('ShaderNodeMath')
	pov_N8.location = (2100, 0)
	pov_N8.operation = 'LESS_THAN'
	pov_N8.use_clamp = True
	pov_N8.inputs[1].default_value = 0.39

	pov_N7.parent = frameFineTune
	pov_N8.parent = frameFineTune

	# link nodes
	igv_group.links.new(pov_N1.outputs[1], pov_N2.inputs[0])
	igv_group.links.new(pov_N1.outputs[4], pov_N2.inputs[1])

	igv_group.links.new(pov_N2.outputs['Value'], pov_N3.inputs['Value'])

	igv_group.links.new(pov_N3.outputs[0], pov_N4.inputs[0])

	igv_group.links.new(
		group_inputs.outputs['Mapping Roughness'], pov_N5.inputs[0])
	
	igv_group.links.new(pov_N5.outputs[0], pov_N51.inputs[0])
	igv_group.links.new(group_inputs.outputs['Roughness Factor'],pov_N51.inputs[1])

	igv_group.links.new(pov_N4.outputs[0], pov_N6.inputs[0])
	igv_group.links.new(pov_N51.outputs[0], pov_N6.inputs[1])

	igv_group.links.new(pov_N6.outputs[0], pov_N7.inputs[0])
	igv_group.links.new(group_inputs.outputs['Factor'], pov_N7.inputs[1])

	igv_group.links.new(pov_N7.outputs[0], pov_N8.inputs[0])
	igv_group.links.new(group_inputs.outputs['Threshold'], pov_N8.inputs[1])

	igv_group.links.new(pov_N8.outputs[0], group_outputs.inputs['Value'])
