import bpy
import bmesh
import os
import re
import math
import mathutils
import json
import pathlib
import datetime
import importlib
import types
from bpy.props import *

from sys import platform as _platform

version = "3.5"

global tUseAbsPath
tUseAbsPath =False

global BasePath
BasePath = ""

pbr_sockets = ['Base Color', 'Subsurface', 'Subsurface Radius', 'Subsurface Color', 'Subsurface IOR', 'Subsurface Anisotropy', 'Metallic', 'Specular', 'Specular Tint', 'Roughness', 'Anisotropic', 'Anisotropic Rotation', 'Sheen', 'Sheen Tint', 'Clearcoat', 'Clearcoat Roughness', 'IOR', 'Transmission', 'Transmission Roughness', 'Emission', 'Emission Strength', 'Alpha', 'Normal', 'Clearcoat Normal', 'Tangent']# store shader sockets in an ordered list to retrieve the socket index when needed

def checkForCtmImporter():
	import bpy as _bpy
	from addon_utils import paths

	path_list = paths()

	for path in path_list:
		_bpy.utils._sys_path_ensure_append(path)
		for mod_name, mod_path in _bpy.path.module_names(path):
			if "ctm" in mod_name.lower() and "import" in mod_name.lower():
				print("CTM importer found")
				return True
	return False
		

def loadNormalMapCombine():
	def loadModule(path):
		loader = importlib.machinery.SourceFileLoader(
			'NormalMapCombine', os.path.join(path, "NormalMapCombine.py"))
		mod = types.ModuleType(loader.name)
		# loader.load_module(mod)
		return loader.load_module(loader.name)
		# loader.exec_module(mod)

	sharedFolder = "Path to Script"

	if bpy.app.background:
		# use this if script started form CMD or Terminal
		try:  # in Shared folder
			sharedFolder = os.path.join(
				os.path.dirname(__file__) + ".", "Shared")
			return loadModule(sharedFolder)
		except OSError:  # in same directory
			sharedFolder = os.path.dirname(__file__)
			return loadModule(sharedFolder)
	else:  # use this if script started from blender
		try:  # in Shared folder
			dirName = os.path.dirname(bpy.path.abspath('//'))
			sharedFolder = os.path.join(
				dirName, "..", "Shared")
			return loadModule(sharedFolder)
		except:  # in same directory
			sharedFolder = os.path.dirname(bpy.path.abspath('//'))
			return loadModule(sharedFolder)


def importScene(index, indexes, path, environment):
	if checkForCtmImporter():
		NormalMapCombine = loadNormalMapCombine()
		NormalMapCombine.NormalMapCombine()
		print("IGXC Blender Importer", version, "Copyright (C) 2018 -",
			datetime.datetime.now().year, "intelligentgraphics AG. All Rights Reserved.")

		# load scene file:
		if ".igxc" in index[indexes]:
			print("INFO", "Processing", index[indexes], "... (IGXC Mode)")
			tFolderPath = index[indexes].rsplit(path, 1)[0] + path
			tScene = json.loads(
				open(tFolderPath + index[indexes].rsplit(path, 1)[1]).read())
		else:
			print("INFO", "Processing", index[indexes], "... (IGX2GO Mode)")
			tFolderPath = index[indexes] + path
			tScene = json.loads(open(tFolderPath + "Scene.igxc").read())

		# check for BasePath and BasePath is no web directory

		if "BasePath" in tScene:
			if not ("http:" in tScene["BasePath"]) and not ("https:" in tScene["BasePath"]):
				print("Useing BasePath")
				global tUseAbsPath
				tUseAbsPath = True
				global BasePath
				BasePath = tScene["BasePath"]


		# remove unused materials:
		for tMaterial in bpy.data.materials:
			if tMaterial.name != "zDummy":
				if tMaterial.users == 0:
					tMaterial.user_clear()
					bpy.data.materials.remove(tMaterial)

				for tTexture in bpy.data.textures:
					if tTexture.users == 0:
						bpy.data.textures.remove(tTexture)

		# create the materials:
		importMaterials(tScene, tFolderPath, environment)

		tGeometries = tScene["Geometries"]
		tMaterialCategories = tScene["Categories"]
		# make sure scene is not empty
		if len(tScene["Objects"]) > 0:
			for tObject in tScene["Objects"]:
				importIGXCNode(tObject, tMaterialCategories,
							tGeometries, tFolderPath, environment, tScene)

		if "GeometryNormalMaps" in tScene and len(tScene["GeometryNormalMaps"]) > 0:
			addNormalsGeometry(
				tScene, "GeometryNormalMaps", tFolderPath, environment)
		else:
			if "GeometryParameters" in tScene and len(tScene["GeometryParameters"]) > 0:
				addNormalsGeometry(
					tScene, "GeometryParameters", tFolderPath, environment)
	else:
		print("Error", "CTM Importer not found!")
		print("Make sure it is installed from the Tools repository")
# End importScene(index,indexes, path, environment)

def buildAbsPath(folderPath, path):
	if tUseAbsPath:
		return os.path.join(BasePath,path)
	else:
		return os.path.join(folderPath,path)

def imagesLoad(folderPath, texturePath): 
	return bpy.data.images.load(buildAbsPath(folderPath, texturePath))

def importMaterials(scene, folderPath, environment):

	def importNodeMaterial(scene, folderPath, environment):
		if "Materials" in scene:
			tMaterials = scene["Materials"]

		def CreateTextureSetUp(pbrNode, igxcMaterial, blenderMaterial, folderPath, pathId):
			tTexturePath = pathId

			tTexturImage = imagesLoad(folderPath, tTexturePath)

			tNode4Image = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeTexImage")
			tNode4Image.image = tTexturImage
			tNode4Image.location = (-600, 300)

			# set up bumpmap here???

			# link image with pbr
			tLink = tMaterial.node_tree.links.new(
				tNode4Image.outputs[0], pbrNode.inputs[pbr_sockets.index('Base Color')])  # Color -> Color

			# link bump here???

		def CreateTextureNormalSetUp(pbrNode, igxcMaterial, blenderMaterial, folderPath):
			tNormal = igxcMaterial["Normal"]
			if "Texture" in igxcMaterial:
				tTexturePath = igxcMaterial["Texture"]  # Name of normal map
			elif "Diffuse" in igxcMaterial:
				tTexturePath = igxcMaterial["Diffuse"]
			else:
				print("ERROR", "No Normalmap found for:", igxcMaterial)

			
			if("Map" in tNormal):
				tTexturePath = tNormal["Map"]

			tTextureImage = imagesLoad(folderPath, tTexturePath)

			tNode4Normals = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeTexImage")
			tNode4Normals.image = tTextureImage
			tNode4Normals.location = (-1000, -300)
			tNode4Normals.image.colorspace_settings.name = 'Non-Color'

			# set up NormalMapCombine?
			tNode5NormalCombine = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeGroup")
			tNode5NormalCombine.node_tree = bpy.data.node_groups["Normal Map Combine"]

			tNode5NormalCombine.inputs[2].default_value = 0.2
			tNode5NormalCombine.location = (-600, -300)

			tLink1 = tMaterial.node_tree.links.new(
				tNode4Normals.outputs[0], tNode5NormalCombine.inputs[1])

			# create roughness map out of normal map
			tNode6RGBtoBW = tMaterial.node_tree.nodes.new(
				type="ShaderNodeRGBToBW")
			tNode6RGBtoBW.location = (-600, -0)

			tNode7ColorRamp = tMaterial.node_tree.nodes.new(
				type="ShaderNodeValToRGB")  # Color Ramp
			tNode7ColorRamp.location = (-400, -0)

			tNode7ColorRamp.color_ramp.elements[0].color = (1, 1, 1, 1)
			tNode7ColorRamp.color_ramp.elements[1].color = (
				0.133, 0.133, 0.133, 1)
			tNode7ColorRamp.color_ramp.elements[1].position = 1
			tNode7ColorRamp.color_ramp.elements[0].position = 0.409091

			tLink2 = blenderMaterial.node_tree.links.new(
				tNode4Normals.outputs[0], tNode6RGBtoBW.inputs[0])
			tLink3 = blenderMaterial.node_tree.links.new(
				tNode6RGBtoBW.outputs[0], tNode7ColorRamp.inputs[0])
			tLink4 = blenderMaterial.node_tree.links.new(
				tNode7ColorRamp.outputs[0], pbrNode.inputs[pbr_sockets.index('Rouhgness')])		 # roughness

			# finish normal map creation

			tNodeNormalMap = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeNormalMap")
			tNodeNormalMap.location = (-400, -230)
			tNodeNormalMap.uv_map = "diffuse_map"
			tNodeNormalMap.inputs[0].default_value = 2

			tLink5 = blenderMaterial.node_tree.links.new(
				tNode5NormalCombine.outputs[0], tNodeNormalMap.inputs[1])
			tLink6 = blenderMaterial.node_tree.links.new(
				tNodeNormalMap.outputs[0], pbrNode.inputs[pbr_sockets.index('Normal')])		 # normal

		def CreateTextureMappingSetUp(mappingType, igxcMaterial, blenderMaterial):
			tNodeImageTex = blenderMaterial.node_tree.nodes.get(
				"Image Texture")
			tMapping = mappingType
			if tMapping != None:
				tTranslationS = tMapping["TranslationS"]
				tTranslationT = tMapping["TranslationT"]
				tRotation = tMapping["Rotation"]
				tScaleS = 1/tMapping["ScaleS"]
				tScaleT = 1/tMapping["ScaleT"]

				tNodeMapping = blenderMaterial.node_tree.nodes.new(
					type="ShaderNodeMapping")
				tNodeMapping.location = (-1500, 300)
				tNodeMapping.vector_type = 'POINT'
				tNodeMapping.inputs[2].default_value[2] =math.pi/180 * tRotation

				tNodeUVMapping = blenderMaterial.node_tree.nodes.new(
					type="ShaderNodeUVMap")
				tNodeUVMapping.name = "UV Map Mapping"
				tNodeUVMapping.location = (-1800, 300)
				tNodeUVMapping.uv_map = "diffuse_map"
				


				tLink1 = blenderMaterial.node_tree.links.new(
					tNodeUVMapping.outputs[0], tNodeMapping.inputs[0])

				tNodeMathScale = blenderMaterial.node_tree.nodes.new(type="ShaderNodeVectorMath")
				tNodeMathScale.location = (-1131.09,227.812)
				tNodeMathScale.operation = 'MULTIPLY'
				tNodeMathScale.inputs[1].default_value = (tScaleS, tScaleT, 1)

				tLink2 = blenderMaterial.node_tree.links.new(tNodeMapping.outputs[0], tNodeMathScale.inputs[0])

				tNodeMathTranslate = blenderMaterial.node_tree.nodes.new(type="ShaderNodeVectorMath")
				tNodeMathTranslate.location = (-898.678,227.812)
				tNodeMathTranslate.operation = 'ADD'
				tNodeMathTranslate.inputs[1].default_value = (tTranslationS, tTranslationT, 0)


				tLink3 = blenderMaterial.node_tree.links.new(
					tNodeMathScale.outputs[0], tNodeMathTranslate.inputs[0])

				tLink4 = blenderMaterial.node_tree.links.new(
					tNodeMathTranslate.outputs[0], tNodeImageTex.inputs[0])

				if "Normal" in igxcMaterial:
					tNodeNormalTex = blenderMaterial.node_tree.nodes.get(
						"Image Texture.001")
					tLink3 = blenderMaterial.node_tree.links.new(
						tNodeMathTranslate.outputs[0], tNodeNormalTex.inputs[0])

		def CreateBumpSetUp(pbrNode, imageNode, normalNode, blenderMaterial, bump, bumpStrength = 0.2):
			if bump:
				tNode5Bump = blenderMaterial.node_tree.nodes.new(
					type="ShaderNodeBump")
				tNode5Bump.location = (-200, -300)
				tNode5Bump.inputs[0].default_value = bumpStrength
				tNode5Bump.inputs[1].default_value = 1.0

				if imageNode:
					tLink1 = blenderMaterial.node_tree.links.new(
						imageNode.outputs[0], tNode5Bump.inputs[2])
				if normalNode:
					tLink2 = blenderMaterial.node_tree.links.new(
						normalNode.outputs['Normal'], tNode5Bump.inputs['Normal'])
				tLink3 = blenderMaterial.node_tree.links.new(
					tNode5Bump.outputs[0], pbrNode.inputs[pbr_sockets.index('Normal')])

		def SetUpTaxonomies(pbrNode, igxcMaterial, metal=0, specular=0, specularTint=0, roughness=0.5, sheen=0, sheenTint=0.5, clearcoat=0, clearcoatRouth=0.03):
			tTaxonomy = igxcMaterial["Taxonomy"]
			if tTaxonomy:
				pbrNode.inputs[pbr_sockets.index('Metallic').default_value = metal
				pbrNode.inputs[pbr_sockets.index('Specular').default_value = specular
				pbrNode.inputs[pbr_sockets.index('Specular Tint').default_value = specularTint
				pbrNode.inputs[pbr_sockets.index('Roughness').default_value = roughness
				pbrNode.inputs[pbr_sockets.index('Sheen').default_value = sheen
				pbrNode.inputs[pbr_sockets.index('Sheen Tint').default_value = sheenTint
				pbrNode.inputs[pbr_sockets.index('Clearcoat').default_value = clearcoat
				pbrNode.inputs[pbr_sockets.index('Clearcoat Roughness').default_value = clearcoatRouth

		def Coating(type, pbrNode):
			if type == "sh":
				pbrNode.inputs[pbr_sockets.index('Clearcoat').default_value = 1 #  clearcoat
				pbrNode.inputs[pbr_sockets.index('Clearcoat Roughness').default_value = 0 #  clearcoatRouth
			elif type == "fi":
				# pbrNode.inputs[5].default_value = 0
				# pbrNode.inputs[pbr_sockets.index('Metallic').default_value = 0
				pbrNode.inputs[pbr_sockets.index('Clearcoat').default_value = 1 #  clearcoat
				pbrNode.inputs[pbr_sockets.index('Clearcoat Roughness').default_value = 0.5 #  clearcoatRouth
			elif type == "an": # ToDo set the values correctly
				pbrNode.inputs[pbr_sockets.index('Metallic').default_value = 0
				pbrNode.inputs[pbr_sockets.index('Specular').default_value = 0
				pbrNode.inputs[pbr_sockets.index('Specular Tint').default_value = 0
				pbrNode.inputs[pbr_sockets.index('Roughness').default_value = 0
				pbrNode.inputs[pbr_sockets.index('Sheen').default_value = 0
				pbrNode.inputs[pbr_sockets.index('Sheen Tint').default_value = 0
				pbrNode.inputs[pbr_sockets.index('Clearcoat').default_value = 0
				pbrNode.inputs[pbr_sockets.index('Clearcoat Roughness').default_value = 0
			elif type == "wa":  # Wax
				pbrNode.inputs[pbr_sockets.index('Clearcoat').default_value = 1	#  clearcoat
				pbrNode.inputs[pbr_sockets.index('Clearcoat Roughness').default_value = 0.35 #  clearcoatRouth
			elif type == "oi":  # Oel
				pbrNode.inputs[pbr_sockets.index('Sheen Tint').default_value = 0.186
				pbrNode.inputs[pbr_sockets.index('Clearcoat').default_value = 0.368
				pbrNode.inputs[pbr_sockets.index('Clearcoat Roughness').default_value = 0.123
			elif type == "pu":  # Matratzenschaumstoff
				pbrNode.inputs[pbr_sockets.index('Specular').default_value = 0
				pbrNode.inputs[pbr_sockets.index('Roughness').default_value = 1 # roughness
				pbrNode.inputs[pbr_sockets.index('Clearcoat').default_value = 0 #  clearcoat
				pbrNode.inputs[pbr_sockets.index('Clearcoat Roughness').default_value = 0 #  clearcoatRouth
			elif type == "ep":  # Epoxidharz
				pbrNode.inputs[pbr_sockets.index('Specular').default_value = 1  #  specular
				pbrNode.inputs[pbr_sockets.index('Clearcoat').default_value =1  #  clearcoat
				pbrNode.inputs[pbr_sockets.index('Clearcoat Roughness').default_value = 0 #  clearcoatRouth

		if "Materials" in scene:
			for tMaterialName in tMaterials:

				# basic material properties
				tJMaterial = tMaterials[tMaterialName]

				tMaterial = bpy.data.materials.new(tMaterialName)
				tMaterial.pass_index = 1  # set pass index for later compositing if glossy mirror
				tMaterial.use_nodes = True

				tDiffuse = [tJMaterial["DiffuseR"],
							tJMaterial["DiffuseG"], tJMaterial["DiffuseB"]]
				tMaterial.diffuse_color[0] = tDiffuse[0]
				tMaterial.diffuse_color[1] = tDiffuse[1]
				tMaterial.diffuse_color[2] = tDiffuse[2]
				tSpecular = [tJMaterial["SpecularR"],
							tJMaterial["SpecularG"], tJMaterial["SpecularB"]]
				tMaterial.specular_color[0] = tSpecular[0]
				tMaterial.specular_color[1] = tSpecular[1]
				tMaterial.specular_color[2] = tSpecular[2]
				tEmissive = [tJMaterial["EmissiveR"],
							tJMaterial["EmissiveG"], tJMaterial["EmissiveB"]]

				tTransparency = tJMaterial["Transparency"]

				tUseBump = False

				# get start node setup
				tNode2 = tMaterial.node_tree.nodes.get("Principled BSDF")

				tNode2.location = (0, 150)
				tNode2.inputs[pbr_sockets.index('Base Color').default_value = (
					tDiffuse[0], tDiffuse[1], tDiffuse[2], 1)					# Diffuse Color
				tNode2.inputs[pbr_sockets.index('Specular').default_value = (
					tSpecular[0] + tSpecular[1] + tSpecular[2])/3				# Specular

				if "Texture" in tJMaterial:
					CreateTextureSetUp(tNode2, tJMaterial,
									tMaterial, folderPath, tJMaterial["Texture"])
					tUseBump = True
				else:
					tNode2.inputs[pbr_sockets.index('Base Color').default_value = [
						tDiffuse[0], tDiffuse[1], tDiffuse[2], 1]
					tUseBump = False

				if "Normal" in tJMaterial:
					CreateTextureNormalSetUp(
						tNode2, tJMaterial, tMaterial, folderPath)
					tUseBump = False
				else:
					if "Texture" in tJMaterial:
						tUseBump = True

				if "Diffuse" in tJMaterial and not "Texture" in tJMaterial:
					tDiffuse = tJMaterial["Diffuse"]
					if("Map" in tDiffuse):
						CreateTextureSetUp(tNode2, tJMaterial,
										tMaterial, folderPath, tDiffuse["Map"])
						tUseBump = True
					else:
						tNode2.inputs[pbr_sockets.index('Base Color').default_value = [
							tDiffuse[0], tDiffuse[1], tDiffuse[2], 1]
						tUseBump = False
					if "Mapping" in tDiffuse:
						CreateTextureMappingSetUp(
							tDiffuse["Mapping"], tJMaterial, tMaterial)

				if "Mapping" in tJMaterial:
					CreateTextureMappingSetUp(
						tJMaterial["Mapping"], tJMaterial, tMaterial)

				tNodeColorRamp = tMaterial.node_tree.nodes.get("ColorRamp")

				# evaluate taxonomies
				BumpStrength = 0.2
				if "Meta" in tJMaterial:
					tMeta = tJMaterial["Meta"]
					if "Taxonomy" in tMeta:
						tWoodIds = ["oak", "beech", "spruc",
									"pine", "maple", "chry", "teak"]
						tFabricIds = ["fabri"]
						tLeatherIds = ["leath"]
						tMetalIds = ["alu", "chro", "hqust", "iron",
									"coppr", "brass", "gold", "silvr"]
						tPolyIds = ["pvc", "polye"]
						tCeramIds = ["ceram"]

						tTaxonomy = tMeta["Taxonomy"]
						tMetaMaterialId = tTaxonomy["mat"]
						if "rou" in tTaxonomy:
							tRoughness = tTaxonomy["rou"]
						tCoating = ""
						if "coa" in tTaxonomy:
							tCoating = tTaxonomy["coa"]

						if tMetaMaterialId in tWoodIds:
							SetUpTaxonomies(tNode2, tMeta,
											0,  # metal
											0.6,  # specular
											0,  # specularTint
											tRoughness,  # roughness
											0,  # sheen
											0.5,  # sheenTint
											0,  # clearcoat
											0.03  # clearcoatRouth
											)
							Coating(tCoating,tNode2)
							if tCoating == "fi":
								tUseBump = False
							if tCoating == "sh":
								tUseBump = False
							if tCoating == "wa":
								BumpStrength = 0.092
							if tCoating == "oi":
								BumpStrength = 0.067
						if tMetaMaterialId in tFabricIds:
							SetUpTaxonomies(tNode2, tMeta,
											0,  # metal
											0,  # specular
											0,  # specularTint
											tRoughness,  # roughness
											0,  # sheen
											0.5,  # sheenTint
											0,  # clearcoat
											0.03  # clearcoatRouth
											)
							# set color ramp
							if tNodeColorRamp != None:
								tNodeColorRamp.color_ramp.elements[1].position = 0.735909
								tNodeColorRamp.color_ramp.elements[0].position = 0.413636
						if tMetaMaterialId in tLeatherIds:
							SetUpTaxonomies(tNode2, tMeta,
											0,  # metal
											1,  # specular
											0,  # specularTint
											tRoughness,  # roughness
											0,  # sheen
											0.5,  # sheenTint
											0,  # clearcoat
											0.03  # clearcoatRouth
											)
							# set color ramp
							if tNodeColorRamp != None:
								tNodeColorRamp.color_ramp.elements[1].position = 1.0
								tNodeColorRamp.color_ramp.elements[0].position = 0.168182
						if tMetaMaterialId in tMetalIds:
							SetUpTaxonomies(tNode2, tMeta,
											1,  # metal
											0.567,  # specular
											0,  # specularTint
											tRoughness,  # roughness
											0,  # sheen
											0.567,  # sheenTint
											0,  # clearcoat
											0.03  # clearcoatRouth
											)
						if tMetaMaterialId in tPolyIds:
							SetUpTaxonomies(tNode2, tMeta,
											0,  # metal
											0.1,  # specular
											0,  # specularTint
											0.1,  # roughness
											0,  # sheen
											0.5,  # sheenTint
											0,  # clearcoat
											0.03  # clearcoatRouth
											)
						if tMetaMaterialId in tCeramIds:
							SetUpTaxonomies(tNode2, tMeta,
											0,  # metal
											1,  # specular
											0.5,  # specularTint
											0,  # roughness
											0,  # sheen
											0.592,  # sheenTint
											0,  # clearcoat
											0.03  # clearcoatRouth
											)
							Coating(tCoating, tNode2)

				# if Bump
				CreateBumpSetUp(tNode2, tMaterial.node_tree.nodes.get(
					"Image Texture"),
					tMaterial.node_tree.nodes.get("Normal Map"), tMaterial, tUseBump, BumpStrength)
				tUseBump = False

	def importCyclesMaterial(scene, folderPath, environment):
		bpy.context.scene.render.engine = "CYCLES"
		# return
		importNodeMaterial(scene, folderPath, environment)
	# importCyclesMaterial End

	def importBlenderMaterial(scene, folderPath, enviornment):
		print("Warning", "Blender internal render enginge has been removed since 2.80. Use Eevee instead!")
		importEeveeMaterial(scene, folderPath, enviornment)
	# importBlenderMaterial End

	def importEeveeMaterial(scene, folderPath, enviornment):
		print("Log", "This is used instead of blender internal render engine")
		bpy.context.scene.render.engine = "BLENDER_EEVEE"
		# return
		importNodeMaterial(scene, folderPath, environment)

	if ("Renderer" in environment):
		if(environment["Renderer"] == "Cycles"):
			# tNormalMapValue =
			importCyclesMaterial(scene, folderPath, environment)
			# return tNormalMapValue
		elif(environment["Renderer"] == "Blender"):
			# tNormalMapValue =
			importBlenderMaterial(scene, folderPath, environment)
			# return tNormalMapValue
		elif(environment["Renderer"] == "Eevee"):
			# tNormalMapValue =
			importEeveeMaterial(scene, folderPath, environment)
			# return tNormalMapValue
	else:
		# use as fallback
		importCyclesMaterial(scene, folderPath, environment)
		# tNormalMapValue = importCyclesMaterial(scene, folderPath, environment)

# End importMaterial


def importIGXCNode(objects, materialCategories, geometries, folderpath, environment, scene):
	
	def setUpTransfromation(objects):
		pX = pY = pZ = 0
		rX = rY = rZ = 0
		sX = sY = sZ = 1

		tUseQuaternion = False

		if "Transform" in objects:
			tTransform = objects["Transform"]
			if "Position" in tTransform:
				tPosition = {}
				if "Position" in tTransform:
					tPosition = tTransform["Position"]
					pX = tPosition["X"]
					pZ = tPosition["Y"]
					pY = -tPosition["Z"]
			if "Rotation" in tTransform:
				tRotation = tTransform["Rotation"]
				if "W" in tRotation:
					if tRotation["W"] <= 1:
						tPosition = {}
						if "Position" in tTransform:
							tPosition = tTransform["Position"]

						setUpQuaternion(rotation = tRotation, position = tPosition)
						tUseQuaternion = True
					else: 
						rX = tRotation["X"] * math.pi / 180
						rZ = tRotation["Y"] * math.pi / 180
						rY = tRotation["Z"] * math.pi / 180
				else:
					rX = tRotation["X"] * math.pi / 180
					rZ = tRotation["Y"] * math.pi / 180
					rY = tRotation["Z"] * math.pi / 180

			if "Scale" in tTransform:
				tScaling = tTransform["Scale"]
				sX = tScaling["X"]
				sZ = tScaling["Y"]
				sY = tScaling["Z"]
		if not tUseQuaternion:
			bpy.ops.object.empty_add(type="PLAIN_AXES", radius=1, location=(
				pX, pY, pZ), rotation=(rX, -rY, rZ))
		bpy.context.object.scale = [sX, sY, sZ]


	def setUpQuaternion(rotation, position):
			pX = pY = pZ = 0
			rX = rY = rZ = 0

			rX = rotation["X"]
			rZ = rotation["Y"]
			rY = rotation["Z"]
			rW = rotation["W"]

			if len(position) > 0:
				pX = position["X"]
				pZ = position["Y"]
				pY = -position["Z"]

			bpy.ops.object.empty_add(type="PLAIN_AXES", radius=1, location=(
				pX, pY, pZ), rotation=(0, -0, 0))
			bpy.context.object.rotation_mode = "QUATERNION"
			bpy.context.object.rotation_quaternion[0] = rW
			bpy.context.object.rotation_quaternion[1] = rX
			bpy.context.object.rotation_quaternion[2] = -rY
			bpy.context.object.rotation_quaternion[3] = rZ
			bpy.context.object.rotation_mode = "XYZ"


	def buildPathName(selectedObject, objects):
		componentPath = objects["Path"]
		selectedObject.name = componentPath

		return componentPath

	def importGeometry(objects, geometries, folderPath):
		tGeometry = objects["Geometry"]

		if tGeometry in geometries:
			tFileImport = buildAbsPath(folderPath, geometries[tGeometry])
			print("Importing File from:", tFileImport)

			# setHighQuali = False
			bpy.ops.object.select_all(action="DESELECT")
			if os.path.exists(tFileImport):
				if tFileImport.endswith("obj"):
					bpy.ops.import_scene.obj(
						filepath=tFileImport, split_mode="OFF")
				elif tFileImport.endswith("ctm"):
					bpy.ops.import_scene.ctm(filepath=tFileImport)
				elif tFileImport.endswith("fbx"):
					bpy.ops.import_scene.fbx(filepath=tFileImport)
					# setHighQuali = True
				else:
					print("ERROR", "File not found:", tFileImport)

				tImportedGeometry = bpy.context.selected_objects[0]
				if len(tImportedGeometry.data.uv_layers) > 0:
					tImportedGeometry.data.uv_layers[0].name = "diffuse_map"
				else:
					print("WARNING", "No uv sets available for Geometry", tGeometry)

				bpy.context.view_layer.objects.active = tImportedGeometry

				bpy.ops.object.shade_smooth()
				tImportedGeometry.name = tGeometry
				tImportedGeometry.data.name = tGeometry
				componentName = tImportedGeometry.name

				bpy.ops.object.transform_apply(
					location=False, rotation=True, scale=False)
				bpy.ops.object.select_all(action="DESELECT")
				bpy.data.objects[componentName].select_set(True)
				bpy.context.view_layer.objects.active = bpy.data.objects[componentName]
				
				# if setHighQuali:
				# 	bpy.ops.object.modifier_add(type='SUBSURF')
				# 	bpy.context.object.modifiers['Subdivision'].levels = 2
				# 	bpy.context.object.modifiers['Subdivision'].render_levels = 2
				
				setHighQuali = False

				return componentName, True
			else:
				print("ERROR", "Cannot resolve geometry", tGeometry)
				return "", False
		else:
			print("ERROR", "Cannot resolve geometry", tGeometry)
			return "", False

	def setGeoMapping(geometry, mapping):

		def calculateTransformation(transMatrix):

			bm = bmesh.new()
			bm.from_mesh(obj.data)

			uv_layer = bm.loops.layers.uv.verify()#bm.loops.layers.uv['diffuse_map'].verify()

			for f in bm.faces:
				for l in f.loops:
					loop_uv = l[uv_layer]
					#print("UV Vector", loop_uv.uv)
					uv4x4 = mathutils.Vector((loop_uv.uv[0], loop_uv.uv[1], 0, 1))

					uv4x4 = uv4x4 @ TransformMatrix

					loop_uv.uv[0] = uv4x4[0]
					loop_uv.uv[1] = uv4x4[1]

			bm.to_mesh(obj.data)
			bm.free()

		# make geometry active
		bpy.data.objects[tComponentName].select_set(True)
		bpy.context.view_layer.objects.active = bpy.data.objects[tComponentName]
		obj = bpy.context.view_layer.objects.active

		# build transformation matrix
		tScaleS =1/mapping["ScaleS"]
		tScaleT = 1/mapping["ScaleT"]
		
		tTranslationS = mapping["TranslationS"]
		tTranslationT = mapping["TranslationT"]

		tRotation = mapping["Rotation"]

		TransMatrix = mathutils.Matrix.Translation((tTranslationS, tTranslationT, 0))
		TransMatrix.transpose()
		ScaleMatrix = mathutils.Matrix.Diagonal((tScaleS, tScaleT, 1.0, 1.0))
		RotMatrix = mathutils.Matrix.Rotation(math.radians(tRotation), 4, 'Z')
		RotMatrix.transpose()

		TransformMatrix = ScaleMatrix@ TransMatrix @RotMatrix

		calculateTransformation(TransformMatrix)

	setUpTransfromation(objects)
	tSelectedObject = bpy.context.object
	tComponentPath = buildPathName(tSelectedObject, objects)
	# check for parent
	if (tComponentPath == "."):
		tParentPath = ""
	elif ("." in tComponentPath):
		tParentPath = tComponentPath[0:tComponentPath.rfind(".")]
	else:
		tParentPath = "."

	tHasParent = False
	if (tParentPath != ""):
		tHasParent = tParentPath in bpy.data.objects

	tHasGeometry = False
	if "Geometry" in objects:
		ImportedGeometriesProp = importGeometry(
			objects, geometries, folderpath)
		tHasGeometry = ImportedGeometriesProp[1]
		tComponentName = ImportedGeometriesProp[0]
		
	tHasMaterial = False
	if"MaterialCategory" in objects:
		tCategory = objects["MaterialCategory"]
		tHasMaterial = False
		if tCategory[:1] == "@":
			# implicit category
			tMaterial = tCategory[1:]
			tHasMaterial = True
		elif tCategory in materialCategories:
			# explicit category
			tMaterial = materialCategories[tCategory]
			tHasMaterial = True
		else:
			print("ERROR", "Cannot resolve Material Category", tCategory)

	if "Mapping" in objects:
		# create mapping for geometry
		tMapping = objects["Mapping"]
		setGeoMapping(tComponentName, tMapping)


	if tHasGeometry:
		bpy.ops.object.select_all(action="DESELECT")
		bpy.data.objects[tComponentName].select_set(True)
		bpy.data.objects[tComponentPath].select_set(True)
		bpy.context.view_layer.objects.active = bpy.data.objects[tComponentPath]
		bpy.ops.object.parent_set(type="OBJECT", keep_transform=True)
		bpy.ops.object.parent_clear(type="CLEAR_INVERSE")

		if (tHasMaterial):
			bpy.data.objects[tComponentName].select_set(True)
			bpy.context.view_layer.objects.active = bpy.data.objects[tComponentName]

			# Delete all native imported materials from object to avoid erros in material rendering:
			bpy.context.active_object.data.materials.clear()

			if bpy.context.active_object.data.materials:
				
				bpy.context.active_object.data.materials[0] = bpy.data.materials.get(
					tMaterial)
				# assignUVMap(bpy.context.active_object.data.materials, bpy.context.active_object.data.name, environment, scene)
			else:
				bpy.context.active_object.data.materials.append(
					bpy.data.materials.get(tMaterial))
				# assignUVMap(bpy.context.active_object.data.materials, bpy.context.active_object.data.name, environment, scene)

	bpy.ops.object.select_all(action="DESELECT")
	bpy.data.objects[tComponentPath].select_set(True)

	# Create parent-child relationship:
	if (tParentPath != ""):
		bpy.data.objects[tParentPath].select_set(True)

		bpy.context.view_layer.objects.active = bpy.data.objects[tParentPath]
		bpy.ops.object.parent_set(type="OBJECT", keep_transform=False)
		bpy.ops.object.parent_clear(type="CLEAR_INVERSE")
# End importIGXCNode


def addNormalsGeometry(scene, normalMapValue, folderPath,  environment):

	def importNodesNormalsGeometry(scene, folderPath, texturePath, blenderMaterial, environment):
		normalMapValue = 0.2
		# take this if it is a shared normal map
		if "NormalMap" in texturePath:
			texturePath = texturePath["NormalMap"]

			

		if pathlib.Path(folderPath + texturePath).is_file():
			tTextureImage = imagesLoad(folderPath, texturePath)

			pbrNode = blenderMaterial.node_tree.nodes.get("Principled BSDF")

			tNode6GeoNormal = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeTexImage")
			tNode6GeoNormal.location = (-1000, 0)
			tNode6GeoNormal.image = tTextureImage
			tNode6GeoNormal.image.colorspace_settings.name = 'Non-Color'

			tNodeUVMap = blenderMaterial.node_tree.nodes.new(
				type="ShaderNodeUVMap")
			tNodeUVMap.location = (-1800, 0)
			tNodeUVMap.uv_map = "object_map"

			Link1 = blenderMaterial.node_tree.links.new(
				tNodeUVMap.outputs[0], tNode6GeoNormal.inputs[0])

			tNodeNormalMapCombine = blenderMaterial.node_tree.nodes.get(
				"Group")
			if tNodeNormalMapCombine != None:
				LinkImageCombine = blenderMaterial.node_tree.links.new(
					tNode6GeoNormal.outputs[0], tNodeNormalMapCombine.inputs[0])
			else:
				tNodeNormalMap = blenderMaterial.node_tree.nodes.new(type = "ShaderNodeNormalMap")
				tNodeNormalMap.location = (-500, 0)
				tNodeNormalMap.uv_map = "object_map"

				tNodeNormalMap.inputs[0].default_value=1 #strength default 1 reference 48
				
				Link2 = blenderMaterial.node_tree.links.new(
					tNode6GeoNormal.outputs[0], tNodeNormalMap.inputs[1]
				)
				tNodeBump = blenderMaterial.node_tree.nodes.get("Bump")
				if tNodeBump != None:
					Link3 = blenderMaterial.node_tree.links.new(tNodeNormalMap.outputs["Normal"], tNodeBump.inputs["Normal"])
				else:
					Link4 = blenderMaterial.node_tree.links.new(tNodeNormalMap.outputs["Normal"], pbrNode.inputs[pbr_sockets.index('Normal')])

	tNormals = scene[normalMapValue]

	# print("VVVVVVVVVVVVVVVVVVVVVVVVVVVVVV")
	# print(json.dumps(scene))

	

	tListMeshes = [tObj for tObj in bpy.data.objects if tObj.type ==
				   'MESH' and tObj.name.startswith("z") == False]

	tObjectsNormalsList = []

	for tObj in tListMeshes:
		tObjectName = tObj.data.name.split(".geo", 1)[0]
		if len(tObjectName.split(".", 3)) > 3:
			tObjectName = tObjectName[:-4]
		
		tNormalGeometry = tObjectName.split("/")
		
		for n in tNormals:
			if tNormalGeometry[len(tNormalGeometry)-1].split('.')[-1] == n.split('.')[-1] :

				tObjectsNormalsList.append(tObj)

	print("-------------------------")
	print('\n'.join([str(tObj) for tObj in tObjectsNormalsList]))

	

	for tObj in tObjectsNormalsList:

		bpy.ops.object.select_all(action="DESELECT")
		bpy.data.objects[tObj.name].select_set(True)
		bpy.context.view_layer.objects.active = bpy.data.objects[tObj.name]

		

		if len(bpy.context.active_object.data.materials) > 0:

			

			tMaterialTemp = bpy.context.active_object.data.materials[0]

			tMaterialNormal = tMaterialTemp.copy()

			bpy.context.active_object.data.materials[0] = tMaterialNormal

			tObjectName = tObj.data.name #.split(".geo", 1)[0]
			# tNewObjectName = ""

			if len(tObjectName.split(".")) > 3:
				tObjectName = tObjectName[:-4]
			
			tTexturePath = tNormals[tObjectName]

			importNodesNormalsGeometry(
				scene, folderPath, tTexturePath, tMaterialNormal, environment)
# End addNormalsGeometry