# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

# <pep8 compliant>

bl_info = {
	"name": "OC Importer",
	"author": "Julia Schubert, Lucas Veber",
	"version": (1, 0, 4),
	"blender": (3, 0 , 0),
	"location": "File > Import-Export",
	"description": "Importer for OpenConfiguration scenes",
	"warning": "",
	#"support": 'UNOFFICIAL',
	"category": "Import-Export"
}


if "bpy" in locals():
	import importlib

	if "oc_import" in locals():
		importlib.reload(oc_import)
	



import bpy
from mathutils import Matrix

from bpy.props import (
		BoolProperty,
		EnumProperty,
		FloatProperty,
		StringProperty,
		)
from bpy_extras.io_utils import (
		ImportHelper,
		orientation_helper,
		axis_conversion,
		)


# @orientation_helper(axis_forward='-Z', axis_up='Y')

		
class ImportOC(bpy.types.Operator, ImportHelper):
	"""Import json from OC archive (.oc)"""
	bl_idname = "import_scene.oc"
	bl_label = 'Import OC'

	filename_ext = ".json"
	filter_glob: StringProperty(
			default="*.json;*.zip",
			options={'HIDDEN'},
			)	
	
	# global_scale: FloatProperty(
	# 		name="Scale",
	# 		description="Scale all transforms",
	# 		min=0.001, max=1000.0,
	# 		soft_min=0.01, soft_max=1000.0,
	# 		default=1.0,
	# 		)
	
				
	def draw(self, context):
		layout = self.layout
		
		# layout.prop(self, "axis_forward")
		# layout.prop(self, "axis_up")
		# layout.prop(self, "global_scale")


	def execute(self, context):
		from . import oc_import

		
		"""
		if obj.type != 'MESH':
			self.report({'ERROR'}, "Select a mesh object")
			return{'FINISHED'}
		"""
			
		
		keywords = self.as_keywords(ignore=("axis_forward",
											"axis_up",
											"filter_glob",
											"check_existing",
											"global_scale"
											#"use_selection"
											))
		
		# global_matrix = (Matrix.Scale(self.global_scale, 4) @
		# 				axis_conversion(from_forward=self.axis_forward,
		# 								from_up=self.axis_up,
		# 								).to_4x4())
		# keywords["global_matrix"] = global_matrix			
		
		
		return oc_import._import(self, context, **keywords)
		
# Add to a menu
def menu_func_import(self, context):
	self.layout.operator(ImportOC.bl_idname, text="OC (.zip)")

classes = (ImportOC,)

def register():
	for cls in classes:
		bpy.utils.register_class(cls)

	bpy.types.TOPBAR_MT_file_import.append(menu_func_import)

def unregister():
	bpy.types.TOPBAR_MT_file_import.remove(menu_func_import)

	for cls in classes:
		bpy.utils.unregister_class(cls)

if __name__ == "__main__":
	register()
