# OpenConfiguration Blender Importer

OpenConfiguration a.k.a. OC (https://docs.openconfiguration.org) is an exchange format for 3D data with special focus on CPQ/3D commerce product representations.

This Importer a.k.a. OC Importer implements the direct import of OC scenes with local asset references into blender.

This addon works with blender versions 3.0 or higher.

## Installation:

This addon requires a CTM Importer addon to be installed. You can download the CTM addon from: https://archive.intelligentgraphics.biz/openconfiguration/blender/OpenCTM_Importer_1.0.5.zip.

After adding the CTM and OpenConfiguration Importer addons, you can import an OC scene by using the menu File > Import > OC (.zip).

OC zips can be downloaded from the ig.Creator pages Products/Graphical/Configurator and Products/Graphics/Planner. 

## How to create an add-on package from scratch manually?

Copy the corresponding OC Importer version (typically the latest blender version) onto your desktop.

Rename the folder OC-Importer.

From the Tools.Blender repo Importers folder, copy the fitting Shared folder version into to OC-Importer folder on you desktop and rename the version number to Shared.

Zip the OC-Importer folder.

This is an example, how the manually created OC-Importer folder structure looks before zipping:

```tex
- OC-Importer
    + Shared
    - __init__.py
    - oc_import.py
```

Note: Make sure, OC Importer and Shared use the same versions. Otherwise package will not work.

## How to create an add-on package from scratch automatically?

Run the powershell script inside the OC-Importer folder.

It will pack a zip ready to install for blender.

## Known Issues

- Blender only can handle object names with max. 63 characters. In case an OC scene is using node or geometry names with more characters, this will break the import.
- The OC Importer does not support deformation.json files
- The OC Importer does not restore animations

## History

**2022-01-31**

1.0.4

- improve robustness

**2022-10-27**

1.0.3

- fix release script

**2022-05-06**

1.0.2

- Zipped file support, automatic extraction

**2022-04-19**

1.0.1

- initial version

## License

See OpenConfiguration License: https://raw.githubusercontent.com/intelligentgraphics/OpenConfiguration/master/LICENSE.txt

## Copyright

Copyright (C) 2020 - 2023 intelligentgraphics AG. All Rights Reserved.